"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryStringManager = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isOfQueryType(arg) {
  return Boolean(arg && 'query' in arg);
}
const useQueryStringManager = props => {
  // Filters should be either what's passed in the initial state or the current state of the filter manager
  const [query, setQuery] = (0, _react.useState)(props.query || props.queryStringManager.getQuery());
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(props.queryStringManager.getUpdates$().subscribe({
      next: () => {
        const newQuery = props.queryStringManager.getQuery();
        setQuery(newQuery);
      }
    }));
    return () => {
      subscriptions.unsubscribe();
    };
  }, [props.queryStringManager]);
  const isQueryType = isOfQueryType(query);
  const stableQuery = (0, _react.useMemo)(() => {
    if (isQueryType) {
      return {
        language: query.language,
        query: query.query
      };
    }
    return query;
  }, [isQueryType, query]);
  return {
    query: stableQuery
  };
};
exports.useQueryStringManager = useQueryStringManager;