"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _helpers = require("../filter_bar/filter_editor/lib/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
class IndexPatternSelect extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isMounted", false);
    (0, _defineProperty2.default)(this, "state", void 0);
    (0, _defineProperty2.default)(this, "fetchSelectedIndexPattern", async indexPatternId => {
      if (!indexPatternId) {
        this.setState({
          selectedIndexPattern: undefined
        });
        return;
      }
      let label;
      try {
        const indexPattern = await this.props.indexPatternService.get(indexPatternId);
        label = indexPattern.getName();
      } catch (err) {
        // index pattern no longer exists
        return;
      }
      if (!this.isMounted) {
        return;
      }
      this.setState({
        selectedIndexPattern: {
          value: indexPatternId,
          label
        }
      });
    });
    (0, _defineProperty2.default)(this, "debouncedFetch", _lodash.default.debounce(async searchValue => {
      const dataViews = await this.props.indexPatternService.getIdsWithTitle();
      if (!this.isMounted || searchValue !== this.state.searchValue) {
        return;
      }
      const options = [];
      for (let i = 0; i < dataViews.length; i++) {
        const label = dataViews[i].name ? dataViews[i].name : dataViews[i].title;
        if (label && label.toLowerCase().includes(searchValue.toLowerCase())) {
          options.push({
            label,
            value: dataViews[i].id
          });
        }
      }
      this.setState({
        isLoading: false,
        options
      });
      if (this.props.onNoIndexPatterns && searchValue === '' && options.length === 0) {
        this.props.onNoIndexPatterns();
      }
    }, 300));
    (0, _defineProperty2.default)(this, "fetchOptions", (searchValue = '') => {
      this.setState({
        isLoading: true,
        searchValue
      }, this.debouncedFetch.bind(null, searchValue));
    });
    (0, _defineProperty2.default)(this, "onChange", selectedOptions => {
      this.props.onChange(_lodash.default.get(selectedOptions, '0.value'));
    });
    this.state = {
      isLoading: false,
      options: [],
      selectedIndexPattern: undefined,
      searchValue: undefined
    };
  }
  componentWillUnmount() {
    this.isMounted = false;
    this.debouncedFetch.cancel();
  }
  componentDidMount() {
    this.isMounted = true;
    this.fetchOptions('');
    this.fetchSelectedIndexPattern(this.props.indexPatternId);
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.indexPatternId !== this.props.indexPatternId) {
      this.fetchSelectedIndexPattern(nextProps.indexPatternId);
    }
  }
  render() {
    const {
      onChange,
      indexPatternId,
      placeholder,
      onNoIndexPatterns,
      indexPatternService,
      ...rest
    } = this.props;
    const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(this.state.options, ['label']);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, rest, {
      placeholder: placeholder,
      singleSelection: true,
      isLoading: this.state.isLoading || this.props.isLoading,
      onSearchChange: this.fetchOptions,
      options: this.state.options,
      selectedOptions: this.state.selectedIndexPattern ? [this.state.selectedIndexPattern] : [],
      onChange: this.onChange,
      truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
      inputPopoverProps: {
        panelMinWidth
      }
    }));
  }
}
exports.default = IndexPatternSelect;
module.exports = exports.default;