"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsEditorInput = ParamsEditorInput;
exports.strings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _filter_editor = require("../../filter_bar/filter_editor");
var _filter_operators = require("../../filter_bar/filter_editor/lib/filter_operators");
var _range_value_input = require("../../filter_bar/filter_editor/range_value_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = exports.strings = {
  getSelectFieldPlaceholderLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.selectFieldPlaceholder', {
    defaultMessage: 'Please select a field first...'
  }),
  getSelectOperatorPlaceholderLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.selectOperatorPlaceholder', {
    defaultMessage: 'Please select operator first...'
  })
};
const getPlaceholderText = (isFieldSelected, isOperatorSelected) => {
  if (!isFieldSelected) {
    return strings.getSelectFieldPlaceholderLabel();
  }
  if (!isOperatorSelected) {
    return strings.getSelectOperatorPlaceholderLabel();
  }
  return '';
};
function ParamsEditorInput({
  dataView,
  field,
  operator,
  params,
  invalid,
  disabled,
  onParamsChange,
  onParamsUpdate,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  suggestionsAbstraction
}) {
  const kibana = (0, _public.useKibana)();
  switch (operator === null || operator === void 0 ? void 0 : operator.type) {
    case 'exists':
      return null;
    case 'phrase':
      return /*#__PURE__*/_react.default.createElement(_filter_editor.PhraseValueInput, {
        compressed: true,
        indexPattern: dataView,
        field: field,
        value: params !== undefined ? `${params}` : undefined,
        onChange: onParamsChange,
        timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
        filtersForSuggestions: filtersForSuggestions,
        fullWidth: true,
        invalid: invalid,
        disabled: disabled,
        suggestionsAbstraction: suggestionsAbstraction
      });
    case 'phrases':
      return /*#__PURE__*/_react.default.createElement(_filter_editor.PhrasesValuesInput, {
        compressed: true,
        indexPattern: dataView,
        field: field,
        values: Array.isArray(params) ? params : undefined,
        onChange: onParamsChange,
        onParamsUpdate: onParamsUpdate,
        timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
        filtersForSuggestions: filtersForSuggestions,
        fullWidth: true,
        disabled: disabled,
        suggestionsAbstraction: suggestionsAbstraction
      });
    case 'range':
      switch (operator.id) {
        case _filter_operators.OPERATORS.GREATER_OR_EQUAL:
          return /*#__PURE__*/_react.default.createElement(_filter_editor.PhraseValueInput, {
            compressed: true,
            indexPattern: dataView,
            onBlur: value => {
              onParamsChange({
                from: (0, _range_value_input.formatDateChange)(value, kibana)
              });
            },
            field: field,
            value: (0, _filter_editor.isRangeParams)(params) && params.from ? `${params.from}` : undefined,
            onChange: value => onParamsChange({
              from: value
            }),
            fullWidth: true,
            invalid: invalid,
            disabled: disabled
          });
        case _filter_operators.OPERATORS.LESS:
          return /*#__PURE__*/_react.default.createElement(_filter_editor.PhraseValueInput, {
            onBlur: value => {
              onParamsChange({
                to: (0, _range_value_input.formatDateChange)(value, kibana)
              });
            },
            compressed: true,
            indexPattern: dataView,
            field: field,
            value: (0, _filter_editor.isRangeParams)(params) && params.to ? `${params.to}` : undefined,
            onChange: value => onParamsChange({
              to: value
            }),
            fullWidth: true,
            invalid: invalid,
            disabled: disabled
          });
        default:
          return /*#__PURE__*/_react.default.createElement(_filter_editor.RangeValueInput, {
            compressed: true,
            field: field,
            value: (0, _filter_editor.isRangeParams)(params) ? params : undefined,
            onChange: onParamsChange,
            fullWidth: true,
            disabled: disabled
          });
      }
    default:
      const placeholderText = getPlaceholderText(Boolean(field), Boolean(operator === null || operator === void 0 ? void 0 : operator.type));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        compressed: true,
        disabled: true,
        placeholder: placeholderText,
        "aria-label": placeholderText
      });
  }
}