"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DataViewPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _change_dataview = require("./change_dataview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

const DataViewPicker = ({
  isMissingCurrent,
  currentDataViewId,
  adHocDataViews,
  savedDataViews,
  onChangeDataView,
  onEditDataView,
  onAddField,
  onDataViewCreated,
  trigger,
  selectableProps,
  textBasedLanguages,
  onSaveTextLanguageQuery,
  onTextLangQuerySubmit,
  textBasedLanguage,
  shouldShowTextBasedLanguageTransitionModal,
  onCreateDefaultAdHocDataView,
  isDisabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_change_dataview.ChangeDataView, {
    isMissingCurrent: isMissingCurrent,
    currentDataViewId: currentDataViewId,
    onChangeDataView: onChangeDataView,
    onEditDataView: onEditDataView,
    onAddField: onAddField,
    onDataViewCreated: onDataViewCreated,
    onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView,
    trigger: trigger,
    adHocDataViews: adHocDataViews,
    savedDataViews: savedDataViews,
    selectableProps: selectableProps,
    textBasedLanguages: textBasedLanguages,
    onSaveTextLanguageQuery: onSaveTextLanguageQuery,
    onTextLangQuerySubmit: onTextLangQuerySubmit,
    textBasedLanguage: textBasedLanguage,
    shouldShowTextBasedLanguageTransitionModal: shouldShowTextBasedLanguageTransitionModal,
    isDisabled: isDisabled
  });
};

// React.lazy support
// eslint-disable-next-line import/no-default-export
exports.DataViewPicker = DataViewPicker;
var _default = exports.default = DataViewPicker;