"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedHistogramSuggestionType = exports.UnifiedHistogramFetchStatus = exports.UnifiedHistogramExternalVisContextStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The fetch status of a Unified Histogram request
 */
let UnifiedHistogramFetchStatus = exports.UnifiedHistogramFetchStatus = /*#__PURE__*/function (UnifiedHistogramFetchStatus) {
  UnifiedHistogramFetchStatus["uninitialized"] = "uninitialized";
  UnifiedHistogramFetchStatus["loading"] = "loading";
  UnifiedHistogramFetchStatus["partial"] = "partial";
  UnifiedHistogramFetchStatus["complete"] = "complete";
  UnifiedHistogramFetchStatus["error"] = "error";
  return UnifiedHistogramFetchStatus;
}({});
/**
 * The services required by the Unified Histogram components
 */
/**
 * The bucketInterval object returned by {@link buildBucketInterval}
 */
/**
 * The adapters passed up from Lens
 */
/**
 * Emitted when the histogram loading status changes
 */
/**
 * Context object for requests made by Unified Histogram components
 */
/**
 * Context object for the hits count
 */
/**
 * Context object for the chart
 */
/**
 * Context object for the histogram breakdown
 */
/**
 * Message to refetch the chart and total hits
 */
/**
 * Unified histogram input message
 */
/**
 * Unified histogram input observable
 */
let UnifiedHistogramExternalVisContextStatus = exports.UnifiedHistogramExternalVisContextStatus = /*#__PURE__*/function (UnifiedHistogramExternalVisContextStatus) {
  UnifiedHistogramExternalVisContextStatus["unknown"] = "unknown";
  UnifiedHistogramExternalVisContextStatus["applied"] = "applied";
  UnifiedHistogramExternalVisContextStatus["automaticallyCreated"] = "automaticallyCreated";
  UnifiedHistogramExternalVisContextStatus["automaticallyOverridden"] = "automaticallyOverridden";
  UnifiedHistogramExternalVisContextStatus["manuallyCustomized"] = "manuallyCustomized";
  return UnifiedHistogramExternalVisContextStatus;
}({});
let UnifiedHistogramSuggestionType = exports.UnifiedHistogramSuggestionType = /*#__PURE__*/function (UnifiedHistogramSuggestionType) {
  UnifiedHistogramSuggestionType["unsupported"] = "unsupported";
  UnifiedHistogramSuggestionType["lensSuggestion"] = "lensSuggestion";
  UnifiedHistogramSuggestionType["histogramForESQL"] = "histogramForESQL";
  UnifiedHistogramSuggestionType["histogramForDataView"] = "histogramForDataView";
  return UnifiedHistogramSuggestionType;
}({});
/**
 * Unified Histogram type for recreating a stored Lens vis
 */