"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.UnifiedHistogramContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _layout = require("../layout");
var _state_service = require("./services/state_service");
var _use_state_props = require("./hooks/use_state_props");
var _use_state_selector = require("./utils/use_state_selector");
var _state_selectors = require("./utils/state_selectors");
var _external_vis_context = require("../utils/external_vis_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The options used to initialize the container
 */

/**
 * The props exposed by the container
 */

/**
 * The API exposed by the container
 */

const UnifiedHistogramContainer = exports.UnifiedHistogramContainer = /*#__PURE__*/(0, _react.forwardRef)(({
  onVisContextChanged,
  ...containerProps
}, ref) => {
  const [layoutProps, setLayoutProps] = (0, _react.useState)();
  const [stateService, setStateService] = (0, _react.useState)();
  const [lensSuggestionsApi, setLensSuggestionsApi] = (0, _react.useState)();
  const [input$] = (0, _react.useState)(() => new _rxjs.Subject());
  const [api, setApi] = (0, _react.useState)();

  // Expose the API to the parent component
  (0, _react.useImperativeHandle)(ref, () => api, [api]);

  // Call for creation options once the container is mounted
  (0, _useMount.default)(async () => {
    const {
      getCreationOptions,
      services
    } = containerProps;
    const options = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());
    const apiHelper = await services.lens.stateHelperApi();
    setLayoutProps((0, _lodash.pick)(options, 'disableAutoFetching', 'disableTriggers', 'disabledActions'));
    setStateService((0, _state_service.createStateService)({
      services,
      ...options
    }));
    setLensSuggestionsApi(() => apiHelper.suggestions);
  });

  // Initialize the API once the state service is available
  (0, _react.useEffect)(() => {
    if (!stateService) {
      return;
    }
    setApi({
      refetch: () => {
        input$.next({
          type: 'refetch'
        });
      },
      ...(0, _lodash.pick)(stateService, 'state$', 'setChartHidden', 'setTopPanelHeight', 'setBreakdownField', 'setTimeInterval', 'setTotalHits')
    });
  }, [input$, stateService]);
  const {
    dataView,
    query,
    searchSessionId,
    requestAdapter,
    isChartLoading
  } = containerProps;
  const topPanelHeight = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.topPanelHeightSelector);
  const stateProps = (0, _use_state_props.useStateProps)({
    stateService,
    dataView,
    query,
    searchSessionId,
    requestAdapter
  });
  const handleVisContextChange = (0, _react.useMemo)(() => {
    if (!onVisContextChanged) {
      return undefined;
    }
    return (visContext, externalVisContextStatus) => {
      const minifiedVisContext = (0, _external_vis_context.exportVisContext)(visContext);
      onVisContextChanged(minifiedVisContext, externalVisContextStatus);
    };
  }, [onVisContextChanged]);

  // Don't render anything until the container is initialized
  if (!layoutProps || !lensSuggestionsApi || !api) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_layout.UnifiedHistogramLayout, (0, _extends2.default)({}, containerProps, layoutProps, stateProps, {
    onVisContextChanged: handleVisContextChange,
    isChartLoading: Boolean(isChartLoading),
    topPanelHeight: topPanelHeight,
    input$: input$,
    lensSuggestionsApi: lensSuggestionsApi
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = UnifiedHistogramContainer;