"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRange = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useTimeRange = ({
  uiSettings,
  bucketInterval,
  timeRange: {
    from,
    to
  },
  timeInterval,
  isPlainRecord,
  timeField
}) => {
  const dateFormat = (0, _react2.useMemo)(() => uiSettings.get('dateFormat'), [uiSettings]);
  const toMoment = (0, _react2.useCallback)(datetime => {
    if (!datetime) {
      return '';
    }
    if (!dateFormat) {
      return String(datetime);
    }
    return datetime.format(dateFormat);
  }, [dateFormat]);
  const timeRangeText = (0, _react2.useMemo)(() => {
    var _bucketInterval$descr;
    if (!timeField && isPlainRecord) {
      return '';
    }
    const timeRange = {
      from: _datemath.default.parse(from),
      to: _datemath.default.parse(to, {
        roundUp: true
      })
    };
    const intervalText = Boolean(isPlainRecord) ? '' : _i18n.i18n.translate('unifiedHistogram.histogramTimeRangeIntervalDescription', {
      defaultMessage: '(interval: {value})',
      values: {
        value: `${timeInterval === 'auto' ? `${_i18n.i18n.translate('unifiedHistogram.histogramTimeRangeIntervalAuto', {
          defaultMessage: 'Auto'
        })} - ` : ''}${(_bucketInterval$descr = bucketInterval === null || bucketInterval === void 0 ? void 0 : bucketInterval.description) !== null && _bucketInterval$descr !== void 0 ? _bucketInterval$descr : _i18n.i18n.translate('unifiedHistogram.histogramTimeRangeIntervalLoading', {
          defaultMessage: 'Loading'
        })}`
      }
    });
    return `${toMoment(timeRange.from)} - ${toMoment(timeRange.to)} ${intervalText}`.trim();
  }, [bucketInterval === null || bucketInterval === void 0 ? void 0 : bucketInterval.description, from, isPlainRecord, timeField, timeInterval, to, toMoment]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const timeRangeCss = (0, _react.css)`
    padding: 0 ${euiTheme.size.s} 0 ${euiTheme.size.s};
  `;
  let timeRangeDisplay = timeRangeText ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center",
    css: timeRangeCss
  }, timeRangeText) : null;
  if (bucketInterval !== null && bucketInterval !== void 0 && bucketInterval.scaled) {
    const toolTipTitle = _i18n.i18n.translate('unifiedHistogram.timeIntervalWithValueWarning', {
      defaultMessage: 'Warning'
    });
    const toolTipContent = _i18n.i18n.translate('unifiedHistogram.bucketIntervalTooltip', {
      defaultMessage: 'This interval creates {bucketsDescription} to show in the selected time range, so it has been scaled to {bucketIntervalDescription}.',
      values: {
        bucketsDescription: bucketInterval.scale && bucketInterval.scale > 1 ? _i18n.i18n.translate('unifiedHistogram.bucketIntervalTooltip.tooLargeBucketsText', {
          defaultMessage: 'buckets that are too large'
        }) : _i18n.i18n.translate('unifiedHistogram.bucketIntervalTooltip.tooManyBucketsText', {
          defaultMessage: 'too many buckets'
        }),
        bucketIntervalDescription: bucketInterval.description
      }
    });
    const timeRangeWrapperCss = (0, _react.css)`
      flex-grow: 0;
    `;
    timeRangeDisplay = /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      justifyContent: "center",
      gutterSize: "none",
      responsive: false,
      css: timeRangeWrapperCss
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, timeRangeDisplay), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      color: "warning",
      title: toolTipTitle,
      content: toolTipContent
    })));
  }
  return {
    timeRangeText,
    timeRangeDisplay
  };
};
exports.useTimeRange = useTimeRange;