"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensProps = exports.getLensProps = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _react = require("react");
var _use_stable_callback = require("../../hooks/use_stable_callback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useLensProps = ({
  request,
  getTimeRange,
  refetch$,
  visContext,
  onLoad
}) => {
  const buildLensProps = (0, _react.useCallback)(() => {
    const {
      attributes,
      requestData
    } = visContext;
    return {
      requestData: JSON.stringify(requestData),
      lensProps: getLensProps({
        searchSessionId: request === null || request === void 0 ? void 0 : request.searchSessionId,
        getTimeRange,
        attributes,
        onLoad
      })
    };
  }, [visContext, getTimeRange, onLoad, request === null || request === void 0 ? void 0 : request.searchSessionId]);
  const [lensPropsContext, setLensPropsContext] = (0, _react.useState)(buildLensProps());
  const updateLensPropsContext = (0, _use_stable_callback.useStableCallback)(() => setLensPropsContext(buildLensProps()));
  (0, _react.useEffect)(() => {
    const subscription = refetch$.subscribe(updateLensPropsContext);
    return () => subscription.unsubscribe();
  }, [refetch$, updateLensPropsContext]);
  return lensPropsContext;
};
exports.useLensProps = useLensProps;
const getLensProps = ({
  searchSessionId,
  getTimeRange,
  attributes,
  onLoad
}) => ({
  id: 'unifiedHistogramLensComponent',
  viewMode: _public.ViewMode.VIEW,
  timeRange: getTimeRange(),
  attributes,
  noPadding: true,
  searchSessionId,
  executionContext: {
    description: 'fetch chart data and total hits'
  },
  onLoad
});
exports.getLensProps = getLensProps;