"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = Chart;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _histogram = require("./histogram");
var _types = require("../types");
var _breakdown_field_selector = require("./breakdown_field_selector");
var _time_interval_selector = require("./time_interval_selector");
var _use_total_hits = require("./hooks/use_total_hits");
var _use_chart_styles = require("./hooks/use_chart_styles");
var _use_chart_actions = require("./hooks/use_chart_actions");
var _chart_config_panel = require("./chart_config_panel");
var _use_refetch = require("./hooks/use_refetch");
var _use_edit_visualization = require("./hooks/use_edit_visualization");
var _lens_vis_from_table = require("../utils/lens_vis_from_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const HistogramMemoized = /*#__PURE__*/(0, _react.memo)(_histogram.Histogram);
function Chart({
  isChartAvailable,
  className,
  services,
  dataView,
  requestParams,
  relativeTimeRange: originalRelativeTimeRange,
  request,
  hits,
  chart,
  breakdown,
  lensVisService,
  isPlainRecord,
  renderCustomChartToggleActions,
  appendHistogram,
  disableAutoFetching,
  disableTriggers,
  disabledActions,
  input$: originalInput$,
  lensAdapters,
  lensEmbeddableOutput$,
  isChartLoading,
  onChartHiddenChange,
  onTimeIntervalChange,
  onBreakdownFieldChange,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd,
  withDefaultActions,
  abortController
}) {
  var _services$capabilitie;
  const lensVisServiceCurrentSuggestionContext = (0, _useObservable.default)(lensVisService.currentSuggestionContext$);
  const visContext = (0, _useObservable.default)(lensVisService.visContext$);
  const currentSuggestion = lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.suggestion;
  const [isSaveModalVisible, setIsSaveModalVisible] = (0, _react.useState)(false);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    chartRef,
    toggleHideChart
  } = (0, _use_chart_actions.useChartActions)({
    chart,
    onChartHiddenChange
  });
  const chartVisible = isChartAvailable && !!chart && !chart.hidden && !!visContext && !!(visContext !== null && visContext !== void 0 && visContext.attributes);
  const input$ = (0, _react.useMemo)(() => originalInput$ !== null && originalInput$ !== void 0 ? originalInput$ : new _rxjs.Subject(), [originalInput$]);
  const {
    filters,
    query,
    getTimeRange,
    updateTimeRange,
    relativeTimeRange
  } = requestParams;
  const refetch$ = (0, _use_refetch.useRefetch)({
    dataView,
    request,
    hits,
    chart,
    chartVisible,
    breakdown,
    filters,
    query,
    relativeTimeRange,
    currentSuggestion,
    disableAutoFetching,
    input$,
    beforeRefetch: updateTimeRange
  });
  (0, _use_total_hits.useTotalHits)({
    services,
    dataView,
    request,
    hits,
    chartVisible,
    filters,
    query,
    getTimeRange,
    refetch$,
    onTotalHitsChange,
    isPlainRecord
  });
  const {
    chartToolbarCss,
    histogramCss
  } = (0, _use_chart_styles.useChartStyles)(chartVisible);
  const onSuggestionContextEdit = (0, _react.useCallback)(editedSuggestionContext => {
    lensVisService.onSuggestionEdited({
      editedSuggestionContext
    });
  }, [lensVisService]);
  (0, _react.useEffect)(() => {
    // close the flyout for dataview mode
    // or if no chart is visible
    if (!chartVisible && isFlyoutVisible) {
      setIsFlyoutVisible(false);
    }
  }, [chartVisible, isFlyoutVisible]);
  const onEditVisualization = (0, _use_edit_visualization.useEditVisualization)({
    services,
    dataView,
    relativeTimeRange: originalRelativeTimeRange !== null && originalRelativeTimeRange !== void 0 ? originalRelativeTimeRange : relativeTimeRange,
    lensAttributes: visContext === null || visContext === void 0 ? void 0 : visContext.attributes,
    isPlainRecord
  });
  const a11yCommonProps = {
    id: 'unifiedHistogramCollapsablePanel'
  };
  if (Boolean(renderCustomChartToggleActions) && !chartVisible) {
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, a11yCommonProps, {
      "data-test-subj": "unifiedHistogramChartPanelHidden"
    }));
  }
  const LensSaveModalComponent = services.lens.SaveModalComponent;
  const hasLensSuggestions = Boolean(isPlainRecord && (lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.type) === _types.UnifiedHistogramSuggestionType.lensSuggestion);
  const canCustomizeVisualization = isPlainRecord && currentSuggestion && [_types.UnifiedHistogramSuggestionType.lensSuggestion, _types.UnifiedHistogramSuggestionType.histogramForESQL].includes(lensVisServiceCurrentSuggestionContext === null || lensVisServiceCurrentSuggestionContext === void 0 ? void 0 : lensVisServiceCurrentSuggestionContext.type);
  const canEditVisualizationOnTheFly = canCustomizeVisualization && chartVisible;
  const canSaveVisualization = canEditVisualizationOnTheFly && ((_services$capabilitie = services.capabilities.dashboard) === null || _services$capabilitie === void 0 ? void 0 : _services$capabilitie.showWriteControls);
  const actions = [];
  if (canEditVisualizationOnTheFly) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
        defaultMessage: 'Edit visualization'
      }),
      iconType: 'pencil',
      isDisabled: isFlyoutVisible,
      'data-test-subj': 'unifiedHistogramEditFlyoutVisualization',
      onClick: () => setIsFlyoutVisible(true)
    });
  } else if (onEditVisualization) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
        defaultMessage: 'Edit visualization'
      }),
      iconType: 'lensApp',
      'data-test-subj': 'unifiedHistogramEditVisualization',
      onClick: onEditVisualization
    });
  }
  if (canSaveVisualization) {
    actions.push({
      label: _i18n.i18n.translate('unifiedHistogram.saveVisualizationButton', {
        defaultMessage: 'Save visualization'
      }),
      iconType: 'save',
      'data-test-subj': 'unifiedHistogramSaveVisualization',
      onClick: () => setIsSaveModalVisible(true)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({}, a11yCommonProps, {
    className: className,
    direction: "column",
    alignItems: "stretch",
    gutterSize: "none",
    responsive: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: chartToolbarCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderCustomChartToggleActions ? renderCustomChartToggleActions() : /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
    legend: _i18n.i18n.translate('unifiedHistogram.hideChartButtongroupLegend', {
      defaultMessage: 'Chart visibility'
    }),
    buttonSize: "s",
    buttons: [{
      label: chartVisible ? _i18n.i18n.translate('unifiedHistogram.hideChartButton', {
        defaultMessage: 'Hide chart'
      }) : _i18n.i18n.translate('unifiedHistogram.showChartButton', {
        defaultMessage: 'Show chart'
      }),
      iconType: chartVisible ? 'transitionTopOut' : 'transitionTopIn',
      'data-test-subj': 'unifiedHistogramToggleChartButton',
      onClick: toggleHideChart
    }]
  })), chartVisible && !isPlainRecord && !!onTimeIntervalChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_time_interval_selector.TimeIntervalSelector, {
    chart: chart,
    onTimeIntervalChange: onTimeIntervalChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement("div", null, chartVisible && breakdown && /*#__PURE__*/_react.default.createElement(_breakdown_field_selector.BreakdownFieldSelector, {
    dataView: dataView,
    breakdown: breakdown,
    onBreakdownFieldChange: onBreakdownFieldChange
  }))))), chartVisible && actions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
    legend: _i18n.i18n.translate('unifiedHistogram.chartActionsGroupLegend', {
      defaultMessage: 'Chart actions'
    }),
    buttonSize: "s",
    buttons: actions
  })))), chartVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("section", {
    ref: element => chartRef.current.element = element,
    tabIndex: -1,
    "aria-label": _i18n.i18n.translate('unifiedHistogram.histogramOfFoundDocumentsAriaLabel', {
      defaultMessage: 'Histogram of found documents'
    }),
    css: histogramCss,
    "data-test-subj": "unifiedHistogramRendered"
  }, isChartLoading &&
  /*#__PURE__*/
  /*
    There are 2 different loaders which can appear above the chart. One is from the embeddable and one is from the UnifiedHistogram.
    The idea is to show UnifiedHistogram loader until we get a new query params which would trigger the embeddable loader.
    Updates to the time range can come earlier than the query updates which we delay on purpose for text based mode,
    this is why it might get both loaders. We should find a way to resolve that better.
  */
  _react.default.createElement(_eui.EuiDelayRender, {
    delay: 500,
    "data-test-subj": "unifiedHistogramProgressBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })), /*#__PURE__*/_react.default.createElement(HistogramMemoized, {
    abortController: abortController,
    services: services,
    dataView: dataView,
    request: request,
    hits: hits,
    chart: chart,
    getTimeRange: getTimeRange,
    refetch$: refetch$,
    visContext: visContext,
    isPlainRecord: isPlainRecord,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    onTotalHitsChange: onTotalHitsChange,
    hasLensSuggestions: hasLensSuggestions,
    onChartLoad: onChartLoad,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd,
    withDefaultActions: withDefaultActions
  })), appendHistogram), canSaveVisualization && isSaveModalVisible && visContext.attributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: (0, _lens_vis_from_table.removeTablesFromLensAttributes)(visContext.attributes),
    onSave: () => {},
    onClose: () => setIsSaveModalVisible(false),
    isSaveable: false
  }), isFlyoutVisible && !!visContext && !!lensVisServiceCurrentSuggestionContext && /*#__PURE__*/_react.default.createElement(_chart_config_panel.ChartConfigPanel, {
    services,
    visContext,
    lensAdapters,
    lensEmbeddableOutput$,
    isFlyoutVisible,
    setIsFlyoutVisible,
    isPlainRecord,
    query,
    currentSuggestionContext: lensVisServiceCurrentSuggestionContext,
    onSuggestionContextEdit
  }));
}