"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setUnifiedDocViewerServices = exports.getUnifiedDocViewerServices = exports.UnifiedDocViewerPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const [getUnifiedDocViewerServices, setUnifiedDocViewerServices] = (0, _public.createGetterSetter)('UnifiedDocViewerServices');
exports.setUnifiedDocViewerServices = setUnifiedDocViewerServices;
exports.getUnifiedDocViewerServices = getUnifiedDocViewerServices;
const DocViewerLegacyTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_table/legacy'))));
const DocViewerTable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_table'))));
const SourceViewer = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/doc_viewer_source'))));
class UnifiedDocViewerPublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "docViewsRegistry", new _unifiedDocViewer.DocViewsRegistry());
  }
  setup(core) {
    this.docViewsRegistry.add({
      id: 'doc_view_table',
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.table.tableTitle', {
        defaultMessage: 'Table'
      }),
      order: 10,
      component: props => {
        const {
          textBasedHits
        } = props;
        const {
          uiSettings
        } = getUnifiedDocViewerServices();
        const DocView = (0, _discoverUtils.isLegacyTableEnabled)({
          uiSettings,
          isTextBasedQueryMode: Array.isArray(textBasedHits)
        }) ? DocViewerLegacyTable : DocViewerTable;
        return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
            delay: 300
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null))
        }, /*#__PURE__*/_react.default.createElement(DocView, props));
      }
    });
    this.docViewsRegistry.add({
      id: 'doc_view_source',
      title: _i18n.i18n.translate('unifiedDocViewer.docViews.json.jsonTitle', {
        defaultMessage: 'JSON'
      }),
      order: 20,
      component: ({
        hit,
        dataView,
        textBasedHits
      }) => {
        var _hit$raw$_id;
        return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
            delay: 300
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null))
        }, /*#__PURE__*/_react.default.createElement(SourceViewer, {
          index: hit.raw._index,
          id: (_hit$raw$_id = hit.raw._id) !== null && _hit$raw$_id !== void 0 ? _hit$raw$_id : hit.id,
          dataView: dataView,
          textBasedHits: textBasedHits,
          hasLineNumbers: true,
          onRefresh: () => {}
        }));
      }
    });
    return {
      registry: this.docViewsRegistry
    };
  }
  start(core, deps) {
    const {
      analytics,
      uiSettings
    } = core;
    const {
      data,
      fieldFormats
    } = deps;
    const storage = new _public.Storage(localStorage);
    const unifiedDocViewer = {
      registry: this.docViewsRegistry
    };
    const services = {
      analytics,
      data,
      fieldFormats,
      storage,
      uiSettings,
      unifiedDocViewer
    };
    setUnifiedDocViewerServices(services);
    return unifiedDocViewer;
  }
}
exports.UnifiedDocViewerPublicPlugin = UnifiedDocViewerPublicPlugin;