"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAIN_COLUMNS = exports.ACTIONS_COLUMN = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _table_cell_actions = require("./table_cell_actions");
var _table_cell_value = require("../table_cell_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTIONS_COLUMN = exports.ACTIONS_COLUMN = {
  field: 'action',
  className: 'kbnDocViewer__tableActionsCell',
  width: '108px',
  mobileOptions: {
    header: false
  },
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.actions",
    defaultMessage: "Actions"
  }))),
  render: ({
    flattenedField,
    isActive,
    onFilter,
    onToggleColumn
  }, {
    field: {
      field,
      fieldMapping
    },
    value: {
      ignored
    }
  }) => {
    return /*#__PURE__*/_react.default.createElement(_table_cell_actions.TableActions, {
      isActive: isActive,
      field: field,
      fieldMapping: fieldMapping,
      flattenedField: flattenedField,
      onFilter: onFilter,
      onToggleColumn: onToggleColumn,
      ignoredValue: !!ignored
    });
  }
};
const MAIN_COLUMNS = exports.MAIN_COLUMNS = [{
  field: 'field',
  className: 'kbnDocViewer__tableFieldNameCell',
  mobileOptions: {
    header: false
  },
  width: '30%',
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.name",
    defaultMessage: "Field"
  }))),
  render: ({
    field,
    fieldType,
    displayName,
    fieldMapping,
    scripted
  }) => {
    return field ? /*#__PURE__*/_react.default.createElement(_unifiedDocViewer.FieldName, {
      fieldName: displayName,
      fieldType: fieldType,
      fieldMapping: fieldMapping,
      scripted: scripted
    }) : /*#__PURE__*/_react.default.createElement("span", null, "\xA0");
  }
}, {
  field: 'value',
  className: 'kbnDocViewer__tableValueCell',
  mobileOptions: {
    header: false
  },
  name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.value",
    defaultMessage: "Value"
  }))),
  render: ({
    formattedValue,
    ignored
  }, {
    field: {
      field
    },
    action: {
      flattenedField
    }
  }) => {
    return /*#__PURE__*/_react.default.createElement(_table_cell_value.TableFieldValue, {
      field: field,
      formattedValue: formattedValue,
      rawValue: flattenedField,
      ignoreReason: ignored
    });
  }
}];