"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiActionsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _triggers = require("@kbn/ui-actions-browser/src/triggers");
var _service = require("./service");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class UiActionsPlugin {
  constructor(_initializerContext) {
    (0, _defineProperty2.default)(this, "service", new _service.UiActionsService());
  }
  setup(_core) {
    this.service.registerTrigger(_triggers.rowClickTrigger);
    this.service.registerTrigger(_triggers.visualizeFieldTrigger);
    this.service.registerTrigger(_triggers.visualizeGeoFieldTrigger);
    return this.service;
  }
  start(core) {
    (0, _services.setAnalytics)(core.analytics);
    (0, _services.setI18n)(core.i18n);
    (0, _services.setTheme)(core.theme);
    return this.service;
  }
  stop() {
    this.service.clear();
  }
}
exports.UiActionsPlugin = UiActionsPlugin;