"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldownCollectConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
require("./index.scss");
var _i18n = require("./i18n");
var _variable_popover = require("../variable_popover");
var _lazy = require("./lazy");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UrlDrilldownCollectConfig = ({
  config,
  variables,
  exampleUrl,
  onConfig,
  syntaxHelpDocsLink,
  variablesHelpDocsLink
}) => {
  var _config$url$template;
  const editorRef = (0, _react.useRef)(null);
  const [isPristine, setIsPristine] = _react.default.useState(true);
  const urlTemplate = (_config$url$template = config.url.template) !== null && _config$url$template !== void 0 ? _config$url$template : '';
  function updateUrlTemplate(newUrlTemplate) {
    if (config.url.template !== newUrlTemplate) {
      setIsPristine(false);
      onConfig({
        ...config,
        url: {
          ...config.url,
          template: newUrlTemplate
        }
      });
    }
  }
  const isEmpty = !urlTemplate;
  const isInvalid = !isPristine && isEmpty;
  const variablesDropdown = /*#__PURE__*/_react.default.createElement(_variable_popover.VariablePopover, {
    variables: variables,
    variablesHelpLink: variablesHelpDocsLink,
    onSelect: variable => {
      const editor = editorRef.current;
      if (!editor) return;
      editor.trigger('keyboard', 'type', {
        text: '{{' + variable + '}}'
      });
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid,
    className: 'uaeUrlDrilldownCollectConfig__urlTemplateFormRow',
    label: _i18n.txtUrlTemplateLabel,
    helpText: syntaxHelpDocsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      target: '_blank',
      href: syntaxHelpDocsLink
    }, _i18n.txtUrlTemplateSyntaxHelpLinkText),
    labelAppend: variablesDropdown
  }, /*#__PURE__*/_react.default.createElement(_public.UrlTemplateEditor, {
    fitToContent: {
      minLines: 5,
      maxLines: 15
    },
    variables: variables,
    value: urlTemplate,
    placeholder: exampleUrl,
    onChange: newUrlTemplate => updateUrlTemplate(newUrlTemplate),
    onEditor: editor => {
      editorRef.current = editor;
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion_url_drilldown_additional_options",
    buttonContent: _i18n.txtUrlTemplateAdditionalOptions,
    "data-test-subj": "urlDrilldownAdditionalOptions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    style: {
      border: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_lazy.UrlDrilldownOptionsComponent, {
    options: {
      ..._constants.DEFAULT_URL_DRILLDOWN_OPTIONS,
      ...config
    },
    onOptionChange: change => {
      onConfig({
        ...config,
        ...change
      });
    }
  }))));
};
exports.UrlDrilldownCollectConfig = UrlDrilldownCollectConfig;