"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtIncompatibleTooltip = exports.TriggerLineItem = void 0;
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _text_with_icon = require("../text_with_icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtIncompatibleTooltip = exports.txtIncompatibleTooltip = _i18n.i18n.translate('uiActionsEnhanced.components.TriggerLineItem.incompatibleTooltip', {
  defaultMessage: 'This trigger type not supported by this panel'
});
const TriggerLineItem = ({
  tooltip,
  incompatible,
  children
}) => {
  return /*#__PURE__*/React.createElement(_text_with_icon.TextWithIcon, {
    color: 'subdued',
    tooltip: tooltip,
    icon: incompatible ? 'warning' : undefined,
    iconColor: incompatible ? 'danger' : undefined,
    iconTooltip: incompatible ? txtIncompatibleTooltip : undefined
  }, children);
};
exports.TriggerLineItem = TriggerLineItem;