"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtTrigger = exports.txtSelectDrilldown = exports.txtName = exports.txtEditDrilldown = exports.txtDeleteDrilldowns = exports.txtCreateDrilldown = exports.txtCloneDrilldown = exports.txtAction = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtCreateDrilldown = exports.txtCreateDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.createDrilldownButtonLabel', {
  defaultMessage: 'Create new'
});
const txtEditDrilldown = exports.txtEditDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.editDrilldownButtonLabel', {
  defaultMessage: 'Edit'
});
const txtCloneDrilldown = exports.txtCloneDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.copyDrilldownButtonLabel', {
  defaultMessage: 'Copy'
});
const txtDeleteDrilldowns = count => _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.deleteDrilldownsButtonLabel', {
  defaultMessage: 'Delete ({count})',
  values: {
    count
  }
});
exports.txtDeleteDrilldowns = txtDeleteDrilldowns;
const txtSelectDrilldown = exports.txtSelectDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.selectThisDrilldownCheckboxLabel', {
  defaultMessage: 'Select this drilldown'
});
const txtName = exports.txtName = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.nameColumnTitle', {
  defaultMessage: 'Name'
});
const txtAction = exports.txtAction = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.actionColumnTitle', {
  defaultMessage: 'Action'
});
const txtTrigger = exports.txtTrigger = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTable.triggerColumnTitle', {
  defaultMessage: 'Trigger'
});