"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_PRESENTABLE_ITEM = exports.PresentablePickerItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
require("./styles.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TEST_SUBJ_PRESENTABLE_ITEM = exports.TEST_SUBJ_PRESENTABLE_ITEM = 'actionFactoryItem';
const PresentablePickerItem = ({
  item,
  context,
  onSelect
}) => {
  var _item$isLicenseCompat;
  const isLicenseCompatible = (_item$isLicenseCompat = item.isLicenseCompatible) !== null && _item$isLicenseCompat !== void 0 ? _item$isLicenseCompat : true;
  const showTooltip = !isLicenseCompatible;
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    className: "auaPresentablePicker__item",
    label: item.getDisplayName(context),
    "data-test-subj": `${TEST_SUBJ_PRESENTABLE_ITEM}-${item.id}`,
    onClick: () => onSelect(item.id),
    disabled: !isLicenseCompatible,
    betaBadgeLabel: item.isBeta ? _i18n.txtBetaActionFactoryLabel : undefined,
    betaBadgeTooltipContent: item.isBeta ? _i18n.txtBetaActionFactoryTooltip : undefined
  }, item.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: item.getIconType(context),
    size: "m"
  }));
  if (showTooltip) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.txtInsufficientLicenseLevel
    }, content);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: item.id
  }, content);
};
exports.PresentablePickerItem = PresentablePickerItem;