"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_ACTION_FACTORY_ITEM = exports.PresentablePicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _presentable_picker_item = require("./presentable_picker_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TEST_SUBJ_ACTION_FACTORY_ITEM = exports.TEST_SUBJ_ACTION_FACTORY_ITEM = 'actionFactoryItem';

// The below style is applied to fix Firefox rendering bug.
// See: https://github.com/elastic/kibana/pull/61219/#pullrequestreview-402903330
const firefoxBugFix = {
  willChange: 'opacity'
};
const sort = (f1, f2) => f2.order - f1.order;
const PresentablePicker = ({
  items,
  context,
  onSelect
}) => {
  /**
   * Make sure items with incompatible license are at the end.
   */
  const itemsSorted = _react.default.useMemo(() => {
    const compatible = items.filter(f => {
      var _f$isLicenseCompatibl;
      return (_f$isLicenseCompatibl = f.isLicenseCompatible) !== null && _f$isLicenseCompatibl !== void 0 ? _f$isLicenseCompatibl : true;
    });
    const incompatible = items.filter(f => {
      var _f$isLicenseCompatibl2;
      return !((_f$isLicenseCompatibl2 = f.isLicenseCompatible) !== null && _f$isLicenseCompatibl2 !== void 0 ? _f$isLicenseCompatibl2 : true);
    });
    return [...compatible.sort(sort), ...incompatible.sort(sort)];
  }, [items]);
  if (items.length === 0) {
    // This is not user facing, as it would be impossible to get into this state
    // just leaving for dev purposes for troubleshooting.
    return /*#__PURE__*/_react.default.createElement("div", null, "No action factories to pick from.");
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: true,
    style: firefoxBugFix
  }, itemsSorted.map(item => /*#__PURE__*/_react.default.createElement(_presentable_picker_item.PresentablePickerItem, {
    key: item.id,
    item: item,
    context: context,
    onSelect: onSelect
  })));
};
exports.PresentablePicker = PresentablePicker;