"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_alerts_table_default_row_actions = require("./common/get_alerts_table_default_row_actions");
var _type_registry = require("./application/type_registry");
var _get_add_connector_flyout = require("./common/get_add_connector_flyout");
var _get_edit_connector_flyout = require("./common/get_edit_connector_flyout");
var _get_add_rule_flyout = require("./common/get_add_rule_flyout");
var _get_edit_rule_flyout = require("./common/get_edit_rule_flyout");
var _get_alerts_table = require("./common/get_alerts_table");
var _get_field_browser = require("./common/get_field_browser");
var _get_rule_status_dropdown = require("./common/get_rule_status_dropdown");
var _get_rule_tag_filter = require("./common/get_rule_tag_filter");
var _get_rule_status_filter = require("./common/get_rule_status_filter");
var _get_rule_tag_badge = require("./common/get_rule_tag_badge");
var _get_rule_event_log_list = require("./common/get_rule_event_log_list");
var _get_rules_list_notify_badge = require("./common/get_rules_list_notify_badge");
var _get_rules_list = require("./common/get_rules_list");
var _get_action_form = require("./common/get_action_form");
var _get_rule_status_panel = require("./common/get_rule_status_panel");
var _experimental_features_service = require("./common/experimental_features_service");
var _experimental_features = require("../common/experimental_features");
var _constants = require("./common/constants");
var _get_alerts_table_state = require("./common/get_alerts_table_state");
var _get_alerts_search_bar = require("./common/get_alerts_search_bar");
var _get_rule_definition = require("./common/get_rule_definition");
var _get_rule_alerts_summary = require("./common/get_rule_alerts_summary");
var _get_rule_snooze_modal = require("./common/get_rule_snooze_modal");
var _get_rules_settings_link = require("./common/get_rules_settings_link");
var _get_global_rule_event_log_list = require("./common/get_global_rule_event_log_list");
var _alert_table_config_registry = require("./application/alert_table_config_registry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "actionTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "alertsTableConfigurationRegistry", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "connectorServices", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.actionTypeRegistry = new _type_registry.TypeRegistry();
    this.ruleTypeRegistry = new _type_registry.TypeRegistry();
    this.alertsTableConfigurationRegistry = new _alert_table_config_registry.AlertTableConfigRegistry();
    this.config = ctx.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []);
  }
  setup(core, plugins) {
    const actionTypeRegistry = this.actionTypeRegistry;
    const ruleTypeRegistry = this.ruleTypeRegistry;
    const alertsTableConfigurationRegistry = this.alertsTableConfigurationRegistry;
    this.connectorServices = {
      validateEmailAddresses: plugins.actions.validateEmailAddresses
    };
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    const featureTitle = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.displayName', {
      defaultMessage: 'Rules'
    });
    const featureDescription = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.displayDescription', {
      defaultMessage: 'Detect conditions using rules.'
    });
    const alertsFeatureTitle = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.alerts.displayName', {
      defaultMessage: 'Alerts'
    });
    const alertsFeatureDescription = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.alerts.displayDescription', {
      defaultMessage: 'Monitor all of your alerts in one place'
    });
    const connectorsFeatureTitle = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.connectors.displayName', {
      defaultMessage: 'Connectors'
    });
    const connectorsFeatureDescription = _i18n.i18n.translate('xpack.triggersActionsUI.managementSection.connectors.displayDescription', {
      defaultMessage: 'Connect third-party software with your alerting data.'
    });
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _constants.PLUGIN_ID,
        title: featureTitle,
        description: featureDescription,
        icon: 'watchesApp',
        path: _ruleDataUtils.triggersActionsRoute,
        showOnHomePage: false,
        category: 'admin'
      });
      plugins.home.featureCatalogue.register({
        id: _constants.CONNECTORS_PLUGIN_ID,
        title: connectorsFeatureTitle,
        description: connectorsFeatureDescription,
        icon: 'watchesApp',
        path: _ruleDataUtils.triggersActionsRoute,
        showOnHomePage: false,
        category: 'admin'
      });
    }
    plugins.management.sections.section.insightsAndAlerting.registerApp({
      id: _constants.PLUGIN_ID,
      title: featureTitle,
      order: 1,
      async mount(params) {
        var _plugins$cloud;
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/rules_app')));

        // The `/api/features` endpoint requires the "Global All" Kibana privilege. Users with a
        // subset of this privilege are not authorized to access this endpoint and will receive a 404
        // error that causes the Alerting view to fail to load.
        let kibanaFeatures;
        try {
          kibanaFeatures = await pluginsStart.features.getFeatures();
        } catch (err) {
          kibanaFeatures = [];
        }
        return renderApp({
          ...coreStart,
          actions: plugins.actions,
          dashboard: pluginsStart.dashboard,
          data: pluginsStart.data,
          dataViews: pluginsStart.dataViews,
          dataViewEditor: pluginsStart.dataViewEditor,
          charts: pluginsStart.charts,
          alerting: pluginsStart.alerting,
          spaces: pluginsStart.spaces,
          unifiedSearch: pluginsStart.unifiedSearch,
          isCloud: Boolean((_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.isCloudEnabled),
          element: params.element,
          theme: params.theme,
          storage: new _public.Storage(window.localStorage),
          setBreadcrumbs: params.setBreadcrumbs,
          history: params.history,
          actionTypeRegistry,
          ruleTypeRegistry,
          alertsTableConfigurationRegistry,
          kibanaFeatures,
          licensing: pluginsStart.licensing,
          expressions: pluginsStart.expressions,
          isServerless: !!pluginsStart.serverless,
          fieldFormats: pluginsStart.fieldFormats,
          lens: pluginsStart.lens
        });
      }
    });
    plugins.management.sections.section.insightsAndAlerting.registerApp({
      id: _constants.CONNECTORS_PLUGIN_ID,
      title: connectorsFeatureTitle,
      order: 2,
      async mount(params) {
        var _plugins$cloud2;
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/connectors_app')));

        // The `/api/features` endpoint requires the "Global All" Kibana privilege. Users with a
        // subset of this privilege are not authorized to access this endpoint and will receive a 404
        // error that causes the Alerting view to fail to load.
        let kibanaFeatures;
        try {
          kibanaFeatures = await pluginsStart.features.getFeatures();
        } catch (err) {
          kibanaFeatures = [];
        }
        return renderApp({
          ...coreStart,
          actions: plugins.actions,
          dashboard: pluginsStart.dashboard,
          data: pluginsStart.data,
          dataViews: pluginsStart.dataViews,
          dataViewEditor: pluginsStart.dataViewEditor,
          charts: pluginsStart.charts,
          alerting: pluginsStart.alerting,
          spaces: pluginsStart.spaces,
          unifiedSearch: pluginsStart.unifiedSearch,
          isCloud: Boolean((_plugins$cloud2 = plugins.cloud) === null || _plugins$cloud2 === void 0 ? void 0 : _plugins$cloud2.isCloudEnabled),
          element: params.element,
          theme$: params.theme$,
          storage: new _public.Storage(window.localStorage),
          setBreadcrumbs: params.setBreadcrumbs,
          history: params.history,
          actionTypeRegistry,
          ruleTypeRegistry,
          alertsTableConfigurationRegistry,
          kibanaFeatures
        });
      }
    });
    if (this.experimentalFeatures.stackAlertsPage) {
      plugins.management.sections.section.insightsAndAlerting.registerApp({
        id: _constants.ALERTS_PAGE_ID,
        title: alertsFeatureTitle,
        capabilitiesId: _constants.PLUGIN_ID,
        order: 0,
        async mount(params) {
          var _plugins$cloud3;
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/alerts_app')));
          const [coreStart, pluginsStart] = await core.getStartServices();
          let kibanaFeatures;
          try {
            kibanaFeatures = await pluginsStart.features.getFeatures();
          } catch (err) {
            kibanaFeatures = [];
          }
          return renderApp({
            ...coreStart,
            actions: plugins.actions,
            dashboard: pluginsStart.dashboard,
            data: pluginsStart.data,
            dataViews: pluginsStart.dataViews,
            dataViewEditor: pluginsStart.dataViewEditor,
            charts: pluginsStart.charts,
            alerting: pluginsStart.alerting,
            spaces: pluginsStart.spaces,
            unifiedSearch: pluginsStart.unifiedSearch,
            isCloud: Boolean((_plugins$cloud3 = plugins.cloud) === null || _plugins$cloud3 === void 0 ? void 0 : _plugins$cloud3.isCloudEnabled),
            element: params.element,
            theme: params.theme,
            storage: new _public.Storage(window.localStorage),
            setBreadcrumbs: params.setBreadcrumbs,
            history: params.history,
            actionTypeRegistry,
            ruleTypeRegistry,
            alertsTableConfigurationRegistry,
            kibanaFeatures,
            licensing: pluginsStart.licensing,
            expressions: pluginsStart.expressions,
            isServerless: !!pluginsStart.serverless,
            fieldFormats: pluginsStart.fieldFormats,
            lens: pluginsStart.lens
          });
        }
      });
      if (plugins.home) {
        plugins.home.featureCatalogue.register({
          id: _constants.ALERTS_PAGE_ID,
          title: alertsFeatureTitle,
          description: alertsFeatureDescription,
          icon: 'watchesApp',
          path: _ruleDataUtils.triggersActionsRoute,
          showOnHomePage: false,
          category: 'admin'
        });
      }
    }
    return {
      actionTypeRegistry: this.actionTypeRegistry,
      ruleTypeRegistry: this.ruleTypeRegistry,
      alertsTableConfigurationRegistry: this.alertsTableConfigurationRegistry
    };
  }
  start(_, plugins) {
    Promise.resolve().then(() => _interopRequireWildcard(require('./application/sections/alerts_table/configuration'))).then(({
      createGenericAlertsTableConfigurations
    }) => {
      createGenericAlertsTableConfigurations(plugins.fieldFormats).forEach(c => this.alertsTableConfigurationRegistry.register(c));
    });
    return {
      actionTypeRegistry: this.actionTypeRegistry,
      ruleTypeRegistry: this.ruleTypeRegistry,
      alertsTableConfigurationRegistry: this.alertsTableConfigurationRegistry,
      getActionForm: props => {
        const {
          setActions,
          ...restProps
        } = props;
        return (0, _get_action_form.getActionFormLazy)({
          ...restProps,
          // TODO remove this cast when every solution is ready to use system actions
          setActions: setActions,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAddConnectorFlyout: props => {
        return (0, _get_add_connector_flyout.getAddConnectorFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getEditConnectorFlyout: props => {
        return (0, _get_edit_connector_flyout.getEditConnectorFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAddRuleFlyout: props => {
        return (0, _get_add_rule_flyout.getAddRuleFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getEditRuleFlyout: props => {
        return (0, _get_edit_rule_flyout.getEditRuleFlyoutLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry,
          connectorServices: this.connectorServices
        });
      },
      getAlertsStateTable: props => {
        return (0, _get_alerts_table_state.getAlertsTableStateLazy)(props);
      },
      getAlertsSearchBar: props => {
        return (0, _get_alerts_search_bar.getAlertsSearchBarLazy)(props);
      },
      getAlertsTable: props => {
        return (0, _get_alerts_table.getAlertsTableLazy)(props);
      },
      getAlertsTableDefaultAlertActions: props => {
        return (0, _get_alerts_table_default_row_actions.getAlertsTableDefaultAlertActionsLazy)(props);
      },
      getFieldBrowser: props => {
        return (0, _get_field_browser.getFieldBrowserLazy)(props);
      },
      getRuleStatusDropdown: props => {
        return (0, _get_rule_status_dropdown.getRuleStatusDropdownLazy)(props);
      },
      getRuleTagFilter: props => {
        return (0, _get_rule_tag_filter.getRuleTagFilterLazy)(props);
      },
      getRuleStatusFilter: props => {
        return (0, _get_rule_status_filter.getRuleStatusFilterLazy)(props);
      },
      getRuleTagBadge: props => {
        return (0, _get_rule_tag_badge.getRuleTagBadgeLazy)(props);
      },
      getRuleEventLogList: props => {
        return (0, _get_rule_event_log_list.getRuleEventLogListLazy)(props);
      },
      getGlobalRuleEventLogList: props => {
        return (0, _get_global_rule_event_log_list.getGlobalRuleEventLogListLazy)(props);
      },
      getRulesListNotifyBadge: props => {
        return (0, _get_rules_list_notify_badge.getRulesListNotifyBadgeLazy)(props);
      },
      getRulesList: props => {
        return (0, _get_rules_list.getRulesListLazy)({
          connectorServices: this.connectorServices,
          rulesListProps: props
        });
      },
      getRuleDefinition: props => {
        return (0, _get_rule_definition.getRuleDefinitionLazy)({
          ...props,
          actionTypeRegistry: this.actionTypeRegistry,
          ruleTypeRegistry: this.ruleTypeRegistry
        });
      },
      getRuleStatusPanel: props => {
        return (0, _get_rule_status_panel.getRuleStatusPanelLazy)(props);
      },
      getAlertSummaryWidget: props => {
        const dependencies = {
          charts: plugins.charts
        };
        return (0, _get_rule_alerts_summary.getAlertSummaryWidgetLazy)({
          ...props,
          dependencies
        });
      },
      getRuleSnoozeModal: props => {
        return (0, _get_rule_snooze_modal.getRuleSnoozeModalLazy)(props);
      },
      getRulesSettingsLink: () => {
        return (0, _get_rules_settings_link.getRulesSettingsLinkLazy)();
      }
    };
  }
  stop() {}
}
exports.Plugin = Plugin;