"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ValueExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValueExpression = ({
  description,
  value,
  onChangeSelectedValue,
  display = 'inline',
  popupPosition,
  errors
}) => {
  const [valuePopoverOpen, setValuePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "valueExpression",
      description: description,
      value: value,
      isActive: valuePopoverOpen,
      display: display === 'inline' ? 'inline' : 'columns',
      onClick: () => {
        setValuePopoverOpen(true);
      },
      isInvalid: errors.length > 0
    }),
    isOpen: valuePopoverOpen,
    closePopover: () => {
      setValuePopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    "data-test-subj": "valueFieldTitle",
    onClose: () => setValuePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "valueFieldNumberForm",
    isInvalid: errors.length > 0 && value !== undefined,
    error: errors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "valueFieldNumber",
    min: 0,
    value: value,
    isInvalid: errors.length > 0 && value !== undefined,
    onChange: e => {
      onChangeSelectedValue(e.target.value);
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ValueExpression = ValueExpression;