"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OfExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _components = require("./components");
require("./of.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OfExpression = ({
  aggType,
  aggField,
  errors,
  onChangeSelectedAggField,
  fields,
  display = 'inline',
  customAggTypesOptions,
  popupPosition,
  helpText
}) => {
  const [aggFieldPopoverOpen, setAggFieldPopoverOpen] = (0, _react.useState)(false);
  const firstFieldOption = {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.of.selectTimeFieldOptionLabel', {
      defaultMessage: 'Select a field'
    }),
    value: ''
  };
  const aggregationTypes = customAggTypesOptions !== null && customAggTypesOptions !== void 0 ? customAggTypesOptions : _constants.builtInAggregationTypes;
  const availableFieldOptions = fields.reduce((esFieldOptions, field) => {
    if (aggregationTypes[aggType].validNormalizedTypes.includes(field.normalizedType)) {
      esFieldOptions.push({
        label: field.name
      });
    }
    return esFieldOptions;
  }, []);
  (0, _react.useEffect)(() => {
    // if current field set doesn't contain selected field, clear selection
    if (aggField && fields.length > 0 && !fields.find(field => field.name === aggField)) {
      onChangeSelectedAggField(undefined);
    }
  }, [aggField, fields, onChangeSelectedAggField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "aggFieldPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.of.buttonLabel', {
        defaultMessage: 'of'
      }),
      "data-test-subj": "ofExpressionPopover",
      display: display === 'inline' ? 'inline' : 'columns',
      value: aggField || firstFieldOption.text,
      isActive: aggFieldPopoverOpen || !aggField,
      onClick: () => {
        setAggFieldPopoverOpen(true);
      },
      isInvalid: !aggField
    }),
    isOpen: aggFieldPopoverOpen,
    closePopover: () => {
      setAggFieldPopoverOpen(false);
    },
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downRight',
    zIndex: 8000,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAggFieldPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.of.popoverTitle",
    defaultMessage: "of"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "actOf__aggFieldContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "ofField",
    fullWidth: true,
    isInvalid: errors.aggField.length > 0 && aggField !== undefined,
    error: errors.aggField,
    "data-test-subj": "availablefieldsOptionsFormRow",
    helpText: helpText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "availablefieldsOptionsComboBox",
    isInvalid: errors.aggField.length > 0 && aggField !== undefined,
    placeholder: firstFieldOption.text,
    options: availableFieldOptions,
    noSuggestions: !availableFieldOptions.length,
    selectedOptions: aggField ? [{
      label: aggField
    }] : [],
    onChange: selectedOptions => {
      onChangeSelectedAggField(selectedOptions.length === 1 ? selectedOptions[0].label : undefined);
      if (selectedOptions.length > 0) {
        setAggFieldPopoverOpen(false);
      }
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.OfExpression = OfExpression;