"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ForLastExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_time_unit_label = require("../lib/get_time_unit_label");
var _get_time_options = require("../lib/get_time_options");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ForLastExpression = ({
  timeWindowSize,
  timeWindowUnit = 's',
  display = 'inline',
  errors,
  onChangeWindowSize,
  onChangeWindowUnit,
  popupPosition
}) => {
  const [alertDurationPopoverOpen, setAlertDurationPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.forTheLast.descriptionLabel', {
        defaultMessage: 'for the last'
      }),
      "data-test-subj": "forLastExpression",
      value: `${timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : '?'} ${(0, _get_time_unit_label.getTimeUnitLabel)(timeWindowUnit, (timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : '').toString())}`,
      isActive: alertDurationPopoverOpen,
      onClick: () => {
        setAlertDurationPopoverOpen(!alertDurationPopoverOpen);
      },
      display: display === 'inline' ? 'inline' : 'columns',
      isInvalid: !timeWindowSize
    }),
    isOpen: alertDurationPopoverOpen,
    closePopover: () => {
      setAlertDurationPopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAlertDurationPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.forTheLast.popoverTitle",
    defaultMessage: "For the last"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: errors.timeWindowSize.length > 0,
    error: errors.timeWindowSize
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "timeWindowSizeNumber",
    isInvalid: errors.timeWindowSize.length > 0,
    min: 0,
    value: timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSizeVal = value !== '' ? parseInt(value, 10) : undefined;
      onChangeWindowSize(timeWindowSizeVal);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "timeWindowUnitSelect",
    value: timeWindowUnit,
    onChange: e => {
      onChangeWindowUnit(e.target.value);
    },
    options: (0, _get_time_options.getTimeOptions)(timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : 1)
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ForLastExpression = ForLastExpression;