"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSNOOZE_SUCCESS_MESSAGE = exports.UNITS_TRANSLATION = exports.SNOOZE_SUCCESS_MESSAGE = exports.SNOOZE_FAILED_MESSAGE = exports.OPEN_SNOOZE_PANEL_ARIA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SNOOZE_SUCCESS_MESSAGE = exports.SNOOZE_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListSnoozePanel.snoozeSuccess', {
  defaultMessage: 'Rules notification successfully snoozed'
});
const UNSNOOZE_SUCCESS_MESSAGE = exports.UNSNOOZE_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListSnoozePanel.unsnoozeSuccess', {
  defaultMessage: 'Rules notification successfully unsnoozed'
});
const SNOOZE_FAILED_MESSAGE = exports.SNOOZE_FAILED_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListSnoozePanel.snoozeFailed', {
  defaultMessage: 'Unable to change rule snooze settings'
});
const OPEN_SNOOZE_PANEL_ARIA_LABEL = exports.OPEN_SNOOZE_PANEL_ARIA_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.openSnoozePanel', {
  defaultMessage: 'Open snooze panel'
});
const getSecondsTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.seconds', {
  defaultMessage: '{value, plural, one {# second} other {# seconds}}',
  values: {
    value
  }
});
const getMinutesTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.minutes', {
  defaultMessage: '{value, plural, one {# minute} other {# minutes}}',
  values: {
    value
  }
});
const getHoursTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.hours', {
  defaultMessage: '{value, plural, one {# hour} other {# hours}}',
  values: {
    value
  }
});
const getDaysTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.days', {
  defaultMessage: '{value, plural, one {# day} other {# days}}',
  values: {
    value
  }
});
const getWeeksTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.weeks', {
  defaultMessage: '{value, plural, one {# week} other {# weeks}}',
  values: {
    value
  }
});
const getMonthsTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.months', {
  defaultMessage: '{value, plural, one {# month} other {# months}}',
  values: {
    value
  }
});
const getYearsTranslation = value => _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.years', {
  defaultMessage: '{value, plural, one {# year} other {# years}}',
  values: {
    value
  }
});
const UNITS_TRANSLATION = exports.UNITS_TRANSLATION = {
  getSecondsTranslation,
  getMinutesTranslation,
  getHoursTranslation,
  getDaysTranslation,
  getWeeksTranslation,
  getMonthsTranslation,
  getYearsTranslation
};