"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleNotifyWhen = exports.NOTIFY_WHEN_OPTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _Option = require("fp-ts/lib/Option");
var _pipeable = require("fp-ts/lib/pipeable");
var _get_time_options = require("../../../common/lib/get_time_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NOTIFY_WHEN_VALUE = 'onActionGroupChange';
const NOTIFY_WHEN_OPTIONS = exports.NOTIFY_WHEN_OPTIONS = [{
  value: 'onActionGroupChange',
  inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.display', {
    defaultMessage: 'On status changes'
  }),
  'data-test-subj': 'onActionGroupChange',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "On status changes",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.label"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions run if the alert status changes.",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActionGroupChange.description"
  }))))
}, {
  value: 'onActiveAlert',
  inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.display', {
    defaultMessage: 'On check intervals'
  }),
  'data-test-subj': 'onActiveAlert',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "On check intervals",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.label"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions run if rule conditions are met.",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onActiveAlert.description"
  }))))
}, {
  value: 'onThrottleInterval',
  inputDisplay: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.display', {
    defaultMessage: 'On custom action intervals'
  }),
  'data-test-subj': 'onThrottleInterval',
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "On custom action intervals",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.label"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Actions run if rule conditions are met.",
    id: "xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.onThrottleInterval.description"
  }))))
}];
const RuleNotifyWhen = ({
  rule,
  throttle,
  throttleUnit,
  onNotifyWhenChange,
  onThrottleChange
}) => {
  const [ruleThrottle, setRuleThrottle] = (0, _react.useState)(throttle || 1);
  const [showCustomThrottleOpts, setShowCustomThrottleOpts] = (0, _react.useState)(false);
  const [notifyWhenValue, setNotifyWhenValue] = (0, _react.useState)(DEFAULT_NOTIFY_WHEN_VALUE);
  (0, _react.useEffect)(() => {
    if (rule.notifyWhen) {
      setNotifyWhenValue(rule.notifyWhen);
    } else {
      // If 'notifyWhen' is not set, derive value from existence of throttle value
      setNotifyWhenValue(rule.throttle ? 'onThrottleInterval' : 'onActiveAlert');
    }
  }, [rule]);
  (0, _react.useEffect)(() => {
    setShowCustomThrottleOpts(notifyWhenValue === 'onThrottleInterval');
  }, [notifyWhenValue]);
  const onNotifyWhenValueChange = (0, _react.useCallback)(newValue => {
    onThrottleChange(newValue === 'onThrottleInterval' ? ruleThrottle : null, throttleUnit);
    onNotifyWhenChange(newValue);
    setNotifyWhenValue(newValue);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const labelForRuleRenotify = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.renotifyFieldLabel",
    defaultMessage: "Notify"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    type: "questionInCircle",
    content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.renotifyWithTooltip', {
      defaultMessage: 'Define how often alerts generate actions.'
    })
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: labelForRuleRenotify
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "notifyWhenSelect",
    options: NOTIFY_WHEN_OPTIONS,
    valueOfSelected: notifyWhenValue,
    onChange: onNotifyWhenValueChange
  }), showCustomThrottleOpts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    value: ruleThrottle,
    name: "throttle",
    "data-test-subj": "throttleInput",
    prepend: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.ruleNotifyWhen.label', {
      defaultMessage: 'Every'
    }),
    onChange: e => {
      (0, _pipeable.pipe)((0, _Option.some)(e.target.value.trim()), (0, _Option.filter)(value => value !== ''), (0, _Option.map)(value => parseInt(value, 10)), (0, _Option.filter)(value => !isNaN(value)), (0, _Option.map)(value => {
        setRuleThrottle(value);
        onThrottleChange(value, throttleUnit);
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "throttleUnitInput",
    value: throttleUnit,
    options: (0, _get_time_options.getTimeOptions)(throttle !== null && throttle !== void 0 ? throttle : 1),
    onChange: e => {
      onThrottleChange(throttle, e.target.value);
    }
  })))))))));
};
exports.RuleNotifyWhen = RuleNotifyWhen;