"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmRuleSave = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmRuleSave = ({
  onConfirm,
  onCancel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleSave.confirmRuleSaveTitle', {
      defaultMessage: 'Save rule with no actions?'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleSave.confirmRuleSaveConfirmButtonText', {
      defaultMessage: 'Save rule'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleSave.confirmRuleSaveCancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    defaultFocusedButton: "confirm",
    "data-test-subj": "confirmRuleSaveModal"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.confirmRuleSave.confirmRuleSaveWithoutActionsMessage",
    defaultMessage: "You can add an action at anytime."
  })));
};
exports.ConfirmRuleSave = ConfirmRuleSave;