"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionSummaryAndChartWithApi = exports.RuleExecutionSummaryAndChart = exports.DEFAULT_NUMBER_OF_EXECUTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../common/lib/kibana");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _execution_duration_chart = require("../../common/components/execution_duration_chart");
var _execution_duration_utils = require("../../../lib/execution_duration_utils");
var _with_bulk_rule_api_operations = require("../../common/components/with_bulk_rule_api_operations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_NUMBER_OF_EXECUTIONS = exports.DEFAULT_NUMBER_OF_EXECUTIONS = 60;
const ruleTypeExcessDurationMessage = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.ruleTypeExcessDurationMessage', {
  defaultMessage: `Duration exceeds the rule's expected run time.`
});
const RuleExecutionSummaryAndChart = props => {
  const {
    ruleId,
    ruleType,
    ruleSummary,
    refreshToken,
    fetchRuleSummary = false,
    numberOfExecutions = DEFAULT_NUMBER_OF_EXECUTIONS,
    onChangeDuration,
    loadRuleSummary,
    isLoadingRuleSummary = false
  } = props;
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isInitialized = (0, _react.useRef)(false);
  const [internalRuleSummary, setInternalRuleSummary] = (0, _react.useState)(null);
  const [internalNumberOfExecutions, setInternalNumberOfExecutions] = (0, _react.useState)(DEFAULT_NUMBER_OF_EXECUTIONS);
  const [internalIsLoadingRuleSummary, setInternalIsLoadingRuleSummary] = (0, _react.useState)(false);

  // Computed values for the separate "mode" where this compute fetches the rule summary by itself
  const computedRuleSummary = (0, _react.useMemo)(() => {
    if (fetchRuleSummary) {
      return internalRuleSummary;
    }
    return ruleSummary;
  }, [fetchRuleSummary, ruleSummary, internalRuleSummary]);
  const computedNumberOfExecutions = (0, _react.useMemo)(() => {
    if (fetchRuleSummary) {
      return internalNumberOfExecutions;
    }
    return numberOfExecutions;
  }, [fetchRuleSummary, numberOfExecutions, internalNumberOfExecutions]);
  const computedIsLoadingRuleSummary = (0, _react.useMemo)(() => {
    if (fetchRuleSummary) {
      return internalIsLoadingRuleSummary;
    }
    return isLoadingRuleSummary;
  }, [fetchRuleSummary, isLoadingRuleSummary, internalIsLoadingRuleSummary]);

  // Computed duration handlers
  const internalOnChangeDuration = (0, _react.useCallback)(duration => {
    setInternalNumberOfExecutions(duration);
  }, [setInternalNumberOfExecutions]);
  const computedOnChangeDuration = (0, _react.useMemo)(() => {
    if (fetchRuleSummary) {
      return internalOnChangeDuration;
    }
    return onChangeDuration || internalOnChangeDuration;
  }, [fetchRuleSummary, onChangeDuration, internalOnChangeDuration]);
  const getRuleSummary = async () => {
    if (!fetchRuleSummary) {
      return;
    }
    setInternalIsLoadingRuleSummary(true);
    try {
      const loadedSummary = await loadRuleSummary(ruleId, computedNumberOfExecutions);
      setInternalRuleSummary(loadedSummary);
    } catch (e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.ruleExecutionSummaryAndChart.loadSummaryError', {
          defaultMessage: 'Unable to load rule summary: {message}',
          values: {
            message: e.message
          }
        })
      });
    }
    setInternalIsLoadingRuleSummary(false);
  };
  (0, _react.useEffect)(() => {
    getRuleSummary();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ruleId, computedNumberOfExecutions]);
  (0, _react.useEffect)(() => {
    if (isInitialized.current) {
      getRuleSummary();
    }
    isInitialized.current = true;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refreshToken]);
  const showDurationWarning = (0, _react.useMemo)(() => {
    if (!computedRuleSummary) {
      return false;
    }
    return (0, _execution_duration_utils.shouldShowDurationWarning)(ruleType, computedRuleSummary.executionDuration.average);
  }, [ruleType, computedRuleSummary]);
  if (!computedRuleSummary) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "avgExecutionDurationPanel",
    color: showDurationWarning ? 'warning' : 'subdued',
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "text"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.avgDurationDescription', {
    defaultMessage: `Average duration`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    style: {
      alignItems: 'center'
    }
  }, showDurationWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "ruleDurationWarning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    anchorClassName: "ruleDurationWarningIcon",
    type: "warning",
    color: "warning",
    content: ruleTypeExcessDurationMessage,
    "aria-label": ruleTypeExcessDurationMessage,
    position: "top",
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "ruleEventLogListAvgDuration"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: euiTheme.colors.text
  }, /*#__PURE__*/_react.default.createElement("strong", null, (0, _execution_duration_utils.formatMillisForDisplay)(computedRuleSummary.executionDuration.average))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_execution_duration_chart.ExecutionDurationChart, {
    executionDuration: computedRuleSummary.executionDuration,
    numberOfExecutions: computedNumberOfExecutions,
    onChangeDuration: computedOnChangeDuration,
    isLoading: computedIsLoadingRuleSummary
  })));
};
exports.RuleExecutionSummaryAndChart = RuleExecutionSummaryAndChart;
const RuleExecutionSummaryAndChartWithApi = exports.RuleExecutionSummaryAndChartWithApi = (0, _with_bulk_rule_api_operations.withBulkRuleOperations)(RuleExecutionSummaryAndChart);