"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CASES", {
  enumerable: true,
  get: function () {
    return _translations.CASES;
  }
});
exports.FILTER_PLACEHOLDER = exports.FIELDS_SHOWING = exports.FIELDS_COUNT = exports.FIELDS_BROWSER = exports.FIELDS = exports.FIELD = exports.DESCRIPTION_FOR_FIELD = exports.DESCRIPTION = exports.CLOSE = exports.CATEGORY = exports.CATEGORIES_COUNT = exports.CATEGORIES = void 0;
Object.defineProperty(exports, "MAINTENANCE_WINDOWS", {
  enumerable: true,
  get: function () {
    return _translations.MAINTENANCE_WINDOWS;
  }
});
exports.VIEW_VALUE_SELECTED = exports.VIEW_VALUE_ALL = exports.VIEW_LABEL = exports.VIEW_COLUMN = exports.RESET_FIELDS = exports.NO_FIELDS_MATCH_INPUT = exports.NO_FIELDS_MATCH = exports.NAME = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORY = exports.CATEGORY = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.categoryLabel', {
  defaultMessage: 'Category'
});
const CATEGORIES = exports.CATEGORIES = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.categoriesTitle', {
  defaultMessage: 'Categories'
});
const CATEGORIES_COUNT = totalCount => _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.categoriesCountTitle', {
  values: {
    totalCount
  },
  defaultMessage: '{totalCount} {totalCount, plural, =1 {category} other {categories}}'
});
exports.CATEGORIES_COUNT = CATEGORIES_COUNT;
const CLOSE = exports.CLOSE = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.closeButton', {
  defaultMessage: 'Close'
});
const FIELDS_BROWSER = exports.FIELDS_BROWSER = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldBrowserTitle', {
  defaultMessage: 'Fields'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.descriptionLabel', {
  defaultMessage: 'Description'
});
const DESCRIPTION_FOR_FIELD = field => _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.descriptionForScreenReaderOnly', {
  values: {
    field
  },
  defaultMessage: 'Description for field {field}:'
});
exports.DESCRIPTION_FOR_FIELD = DESCRIPTION_FOR_FIELD;
const NAME = exports.NAME = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldName', {
  defaultMessage: 'Name'
});
const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldLabel', {
  defaultMessage: 'Field'
});
const FIELDS = exports.FIELDS = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldsTitle', {
  defaultMessage: 'Fields'
});
const FIELDS_SHOWING = exports.FIELDS_SHOWING = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldsCountShowing', {
  defaultMessage: 'Showing'
});
const FIELDS_COUNT = totalCount => _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.fieldsCountTitle', {
  values: {
    totalCount
  },
  defaultMessage: '{totalCount, plural, =1 {field} other {fields}}'
});
exports.FIELDS_COUNT = FIELDS_COUNT;
const FILTER_PLACEHOLDER = exports.FILTER_PLACEHOLDER = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.filterPlaceholder', {
  defaultMessage: 'Field name'
});
const NO_FIELDS_MATCH = exports.NO_FIELDS_MATCH = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.noFieldsMatchLabel', {
  defaultMessage: 'No fields match'
});
const NO_FIELDS_MATCH_INPUT = searchInput => _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.noFieldsMatchInputLabel', {
  defaultMessage: 'No fields match {searchInput}',
  values: {
    searchInput
  }
});
exports.NO_FIELDS_MATCH_INPUT = NO_FIELDS_MATCH_INPUT;
const RESET_FIELDS = exports.RESET_FIELDS = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.resetFieldsLink', {
  defaultMessage: 'Reset Fields'
});
const VIEW_COLUMN = field => _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.viewColumnCheckboxAriaLabel', {
  values: {
    field
  },
  defaultMessage: 'View {field} column'
});
exports.VIEW_COLUMN = VIEW_COLUMN;
const VIEW_LABEL = exports.VIEW_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.viewLabel', {
  defaultMessage: 'View'
});
const VIEW_VALUE_SELECTED = exports.VIEW_VALUE_SELECTED = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.viewSelected', {
  defaultMessage: 'selected'
});
const VIEW_VALUE_ALL = exports.VIEW_VALUE_ALL = _i18n.i18n.translate('xpack.triggersActionsUI.fieldBrowser.viewAll', {
  defaultMessage: 'all'
});