"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTableHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
var _field_table_header = require("./field_table_header.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldTableHeaderComponent = ({
  fieldCount,
  filterSelectedEnabled,
  onFilterSelectedChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "fields-showing",
    size: "xs"
  }, i18n.FIELDS_SHOWING, /*#__PURE__*/_react.default.createElement("span", {
    css: _field_table_header.styles.count,
    "data-test-subj": "fields-count"
  }, ' ', fieldCount, ' '), i18n.FIELDS_COUNT(fieldCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "viewSelectorButton",
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover
    }, `${i18n.VIEW_LABEL}: ${filterSelectedEnabled ? i18n.VIEW_VALUE_SELECTED : i18n.VIEW_VALUE_ALL}`)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "viewSelectorMenu",
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "viewSelectorOption-all",
      key: "viewAll",
      icon: filterSelectedEnabled ? 'empty' : 'check',
      onClick: () => {
        onFilterSelectedChange(false);
        closePopover();
      }
    }, `${i18n.VIEW_LABEL} ${i18n.VIEW_VALUE_ALL}`), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: "separator",
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "viewSelectorOption-selected",
      key: "viewSelected",
      icon: filterSelectedEnabled ? 'check' : 'empty',
      onClick: () => {
        onFilterSelectedChange(true);
        closePopover();
      }
    }, `${i18n.VIEW_LABEL} ${i18n.VIEW_VALUE_SELECTED}`)]
  }))));
};
const FieldTableHeader = exports.FieldTableHeader = /*#__PURE__*/_react.default.memo(FieldTableHeaderComponent);