"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Renders a field name in it's non-dragging state */
const FieldName = exports.FieldName = /*#__PURE__*/_react.default.memo(({
  fieldId,
  highlight = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    "data-test-subj": `field-${fieldId}-name`,
    search: highlight
  }, fieldId));
});
FieldName.displayName = 'FieldName';