"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isActionsColumn = exports.getFieldItemsData = exports.getFieldColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _ecs = require("@elastic/ecs");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _field_name = require("../field_name");
var i18n = _interopRequireWildcard(require("../../translations"));
var _field_items = require("./field_items.style");
var _helpers = require("../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * For the Cases field we want to change the
 * name of the field from kibana.alert.case_ids to Cases.
 */
const getFieldItemName = name => {
  if (name === _ruleDataUtils.ALERT_CASE_IDS) {
    return i18n.CASES;
  }
  if (name === _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS) {
    return i18n.MAINTENANCE_WINDOWS;
  }
  return name;
};

/**
 * Returns the field items of all categories selected
 */
const getFieldItemsData = ({
  browserFields,
  selectedCategoryIds,
  columnIds
}) => {
  const categoryIds = selectedCategoryIds.length > 0 ? selectedCategoryIds : Object.keys(browserFields);
  const selectedFieldIds = new Set(columnIds);
  const fieldItems = (0, _fp.uniqBy)('name', categoryIds.reduce((fieldItemsAcc, categoryId) => {
    var _browserFields$catego, _browserFields$catego2;
    const categoryBrowserFields = Object.values((_browserFields$catego = (_browserFields$catego2 = browserFields[categoryId]) === null || _browserFields$catego2 === void 0 ? void 0 : _browserFields$catego2.fields) !== null && _browserFields$catego !== void 0 ? _browserFields$catego : {});
    if (categoryBrowserFields.length > 0) {
      fieldItemsAcc.push(...categoryBrowserFields.map(({
        name = '',
        ...field
      }) => {
        var _field$example;
        return {
          name,
          type: field.type,
          description: (0, _helpers.getDescription)(name, _ecs.EcsFlat),
          example: (_field$example = field.example) === null || _field$example === void 0 ? void 0 : _field$example.toString(),
          category: (0, _helpers.getCategory)(name),
          selected: selectedFieldIds.has(name),
          isRuntime: !!field.runtimeField
        };
      }));
    }
    return fieldItemsAcc;
  }, []));
  return {
    fieldItems
  };
};
exports.getFieldItemsData = getFieldItemsData;
const getDefaultFieldTableColumns = ({
  highlight
}) => {
  const nameColumn = {
    field: 'name',
    name: i18n.NAME,
    render: (name, {
      type
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: type
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        "data-test-subj": `field-${name}-icon`,
        css: _field_items.styles.icon,
        type: (0, _helpers.getIconFromType)(type !== null && type !== void 0 ? type : null)
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_field_name.FieldName, {
        fieldId: getFieldItemName(name),
        highlight: highlight
      })));
    },
    sortable: true,
    width: '225px'
  };
  const descriptionColumn = {
    field: 'description',
    name: i18n.DESCRIPTION,
    render: (description, {
      name,
      example
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      "data-test-subj": "descriptionForScreenReaderOnly"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION_FOR_FIELD(name))), /*#__PURE__*/_react.default.createElement("span", {
      css: _field_items.styles.truncatable
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: _field_items.styles.description,
      "data-test-subj": `field-${name}-description`
    }, `${description !== null && description !== void 0 ? description : (0, _helpers.getEmptyValue)()} ${(0, _helpers.getExampleText)(example)}`)))),
    sortable: true,
    width: '400px'
  };
  const categoryColumn = {
    field: 'category',
    name: i18n.CATEGORY,
    render: (category, {
      name
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": `field-${name}-category`
    }, category),
    sortable: true,
    width: '130px'
  };
  return [nameColumn, ...[descriptionColumn], categoryColumn];
};

/**
 * Returns a table column template provided to the `EuiInMemoryTable`'s
 * `columns` prop
 */
const getFieldColumns = ({
  getFieldTableColumns,
  highlight = '',
  onHide,
  onToggleColumn
}) => [{
  field: 'selected',
  name: '',
  render: (selected, {
    name
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.VIEW_COLUMN(name)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": i18n.VIEW_COLUMN(name),
    checked: selected,
    "data-test-subj": `field-${name}-checkbox`,
    "data-colindex": 1,
    id: name,
    onChange: () => onToggleColumn(name)
  })),
  sortable: false,
  width: '25px'
}, ...(getFieldTableColumns ? getFieldTableColumns({
  highlight,
  onHide
}) : getDefaultFieldTableColumns({
  highlight
}))];

/** Returns whether the table column has actions attached to it */
exports.getFieldColumns = getFieldColumns;
const isActionsColumn = column => {
  var _actions;
  return !!((_actions = column.actions) !== null && _actions !== void 0 && _actions.length);
};
exports.isActionsColumn = isActionsColumn;