"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERTS_TABLE_UNKNOWN_ERROR_TITLE = exports.ALERTS_TABLE_UNKNOWN_ERROR_MESSAGE = exports.ALERTS_TABLE_UNKNOWN_ERROR_COPY_TO_CLIPBOARD_LABEL = exports.ALERTS_TABLE_TITLE = exports.ALERTS_TABLE_FILTERS_ERROR_TITLE = exports.ALERTS_TABLE_CONTROL_COLUMNS_ACTIONS_LABEL = exports.ALERTS_TABLE_CONF_ERROR_TITLE = exports.ALERTS_TABLE_CONF_ERROR_MESSAGE = void 0;
Object.defineProperty(exports, "CASES", {
  enumerable: true,
  get: function () {
    return _translations.CASES;
  }
});
Object.defineProperty(exports, "MAINTENANCE_WINDOWS", {
  enumerable: true,
  get: function () {
    return _translations.MAINTENANCE_WINDOWS;
  }
});
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_TABLE_CONF_ERROR_TITLE = exports.ALERTS_TABLE_CONF_ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.configuration.errorTitle', {
  defaultMessage: 'Unable to load alerts table'
});
const ALERTS_TABLE_CONF_ERROR_MESSAGE = exports.ALERTS_TABLE_CONF_ERROR_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.configuration.errorBody', {
  defaultMessage: 'There was an error loading the alerts table. This table is missing the necessary configuration. Please contact your administrator for help'
});
const ALERTS_TABLE_CONTROL_COLUMNS_ACTIONS_LABEL = exports.ALERTS_TABLE_CONTROL_COLUMNS_ACTIONS_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.column.actions', {
  defaultMessage: 'Actions'
});
const ALERTS_TABLE_TITLE = exports.ALERTS_TABLE_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.title', {
  defaultMessage: 'Alerts table'
});
const ALERTS_TABLE_FILTERS_ERROR_TITLE = exports.ALERTS_TABLE_FILTERS_ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.filters.errorTitle', {
  defaultMessage: 'Unsupported alerts filters set'
});
const ALERTS_TABLE_UNKNOWN_ERROR_TITLE = exports.ALERTS_TABLE_UNKNOWN_ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.unknownErrorTitle', {
  defaultMessage: 'Cannot display alerts'
});
const ALERTS_TABLE_UNKNOWN_ERROR_MESSAGE = exports.ALERTS_TABLE_UNKNOWN_ERROR_MESSAGE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.unknownErrorBody', {
  defaultMessage: 'An error occurred while rendering the alerts table'
});
const ALERTS_TABLE_UNKNOWN_ERROR_COPY_TO_CLIPBOARD_LABEL = exports.ALERTS_TABLE_UNKNOWN_ERROR_COPY_TO_CLIPBOARD_LABEL = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.unknownErrorCopyToClipboardLabel', {
  defaultMessage: 'Copy error to clipboard'
});