"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetToolbarVisibility = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alerts_count = require("./components/alerts_count/alerts_count");
var _alerts_table_context = require("../contexts/alerts_table_context");
var _last_updated_at = require("./components/last_updated_at");
var _field_browser = require("../../field_browser");
var _inspect = require("./components/inspect");
var _translations = require("../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BulkActionsToolbar = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../bulk_actions/components/toolbar'))));
const RightControl = /*#__PURE__*/(0, _react.memo)(({
  controls,
  getInspectQuery,
  showInspectButton
}) => {
  const {
    bulkActions: [bulkActionsState]
  } = (0, _react.useContext)(_alerts_table_context.AlertsTableContext);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInspectButton && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    inspectTitle: _translations.ALERTS_TABLE_TITLE,
    getInspectQuery: getInspectQuery
  }), /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
    updatedAt: bulkActionsState.updatedAt
  }), controls === null || controls === void 0 ? void 0 : controls.right);
});
const LeftAppendControl = /*#__PURE__*/(0, _react.memo)(({
  alertsCount,
  hasBrowserFields,
  columnIds,
  browserFields,
  onResetColumns,
  onToggleColumn,
  fieldBrowserOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_count.AlertsCount, {
    count: alertsCount
  }), hasBrowserFields && /*#__PURE__*/_react.default.createElement(_field_browser.FieldBrowser, {
    columnIds: columnIds,
    browserFields: browserFields,
    onResetColumns: onResetColumns,
    onToggleColumn: onToggleColumn,
    options: fieldBrowserOptions
  }));
});
const useGetDefaultVisibility = ({
  alertsCount,
  columnIds,
  onToggleColumn,
  onResetColumns,
  browserFields,
  controls,
  fieldBrowserOptions,
  getInspectQuery,
  showInspectButton,
  toolbarVisibilityProp
}) => {
  const defaultVisibility = (0, _react.useMemo)(() => {
    const hasBrowserFields = Object.keys(browserFields).length > 0;
    return {
      additionalControls: {
        right: /*#__PURE__*/_react.default.createElement(RightControl, {
          controls: controls,
          getInspectQuery: getInspectQuery,
          showInspectButton: showInspectButton
        }),
        left: {
          append: /*#__PURE__*/_react.default.createElement(LeftAppendControl, {
            alertsCount: alertsCount,
            hasBrowserFields: hasBrowserFields,
            columnIds: columnIds,
            browserFields: browserFields,
            onResetColumns: onResetColumns,
            onToggleColumn: onToggleColumn,
            fieldBrowserOptions: fieldBrowserOptions
          })
        }
      },
      showColumnSelector: {
        allowHide: false
      },
      showSortSelector: true
    };
  }, [alertsCount, browserFields, columnIds, fieldBrowserOptions, getInspectQuery, onResetColumns, onToggleColumn, showInspectButton, controls]);
  return defaultVisibility;
};
const useGetToolbarVisibility = ({
  bulkActions,
  alertsCount,
  rowSelection,
  alerts,
  isLoading,
  columnIds,
  onToggleColumn,
  onResetColumns,
  browserFields,
  setIsBulkActionsLoading,
  clearSelection,
  controls,
  refresh,
  fieldBrowserOptions,
  getInspectQuery,
  showInspectButton,
  toolbarVisibilityProp
}) => {
  const selectedRowsCount = rowSelection.size;
  const defaultVisibilityProps = (0, _react.useMemo)(() => {
    return {
      alertsCount,
      columnIds,
      onToggleColumn,
      onResetColumns,
      browserFields,
      controls,
      fieldBrowserOptions,
      getInspectQuery,
      showInspectButton
    };
  }, [alertsCount, columnIds, onToggleColumn, onResetColumns, browserFields, controls, fieldBrowserOptions, getInspectQuery, showInspectButton]);
  const defaultVisibility = useGetDefaultVisibility(defaultVisibilityProps);
  const options = (0, _react.useMemo)(() => {
    const isBulkActionsActive = selectedRowsCount === 0 || selectedRowsCount === undefined || bulkActions.length === 0;
    if (isBulkActionsActive) {
      return {
        ...defaultVisibility,
        ...(toolbarVisibilityProp !== null && toolbarVisibilityProp !== void 0 ? toolbarVisibilityProp : {})
      };
    } else {
      return {
        showColumnSelector: false,
        showSortSelector: false,
        additionalControls: {
          right: /*#__PURE__*/_react.default.createElement(RightControl, {
            controls: controls,
            getInspectQuery: getInspectQuery,
            showInspectButton: showInspectButton
          }),
          left: {
            append: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_count.AlertsCount, {
              count: alertsCount
            }), /*#__PURE__*/_react.default.createElement(_react.Suspense, {
              fallback: null
            }, /*#__PURE__*/_react.default.createElement(BulkActionsToolbar, {
              totalItems: alertsCount,
              panels: bulkActions,
              alerts: alerts,
              setIsBulkActionsLoading: setIsBulkActionsLoading,
              clearSelection: clearSelection,
              refresh: refresh
            })))
          }
        },
        ...(toolbarVisibilityProp !== null && toolbarVisibilityProp !== void 0 ? toolbarVisibilityProp : {})
      };
    }
  }, [alertsCount, bulkActions, defaultVisibility, selectedRowsCount, toolbarVisibilityProp, alerts, clearSelection, refresh, setIsBulkActionsLoading, controls, getInspectQuery, showInspectButton]);
  return options;
};
exports.useGetToolbarVisibility = useGetToolbarVisibility;