"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActionsCell = AlertActionsCell;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _get_alerts_table_default_row_actions = require("../../../../common/get_alerts_table_default_row_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionsToolTip = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.moreActionsTextLabel', {
  defaultMessage: 'More actions'
});

/**
 * The cell containing contextual actions for a single alert row in the table
 */
function AlertActionsCell(alertActionsProps) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const DefaultRowActions = (0, _react.useMemo)(() => (0, _get_alerts_table_default_row_actions.getAlertsTableDefaultAlertActionsLazy)({
    key: 'defaultRowActions',
    onActionExecuted: closeActionsPopover,
    isAlertDetailsEnabled: false,
    ...alertActionsProps
  }), [alertActionsProps]);

  // TODO re-enable view in app when it works
  const actionsMenuItems = [DefaultRowActions];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s"
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems,
    "data-test-subj": "alertsTableActionsMenu"
  }))));
}