"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSorting = useSorting;
var _react = require("react");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatGridColumns = cols => {
  const colsSorting = [];
  cols.forEach(col => {
    Object.entries(col).forEach(([field, oSort]) => {
      colsSorting.push({
        id: field,
        direction: oSort.order
      });
    });
  });
  return colsSorting;
};
function useSorting(onSortChange, visibleColumns, defaultSort = _constants.DefaultSort) {
  const [visibleColumnsSort, invisibleColumnsSort] = (0, _react.useMemo)(() => {
    const visibleSort = [];
    const invisibleSort = [];
    defaultSort.forEach(sortCombinations => {
      if (visibleColumns.includes(Object.keys(sortCombinations)[0])) {
        visibleSort.push(sortCombinations);
      } else {
        invisibleSort.push(...formatGridColumns([sortCombinations]));
      }
    });
    return [visibleSort, invisibleSort];
  }, [defaultSort, visibleColumns]);
  const [sortingColumns, setSortingColumns] = (0, _react.useState)(formatGridColumns(visibleColumnsSort));
  const onSort = (0, _react.useCallback)(sortingConfig => {
    onSortChange([...sortingConfig, ...invisibleColumnsSort]);
    setSortingColumns(sortingConfig);
  }, [onSortChange, invisibleColumnsSort]);
  return {
    sortingColumns,
    onSort
  };
}