"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleColumn = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const remove = ({
  columns,
  index
}) => {
  return [...columns.slice(0, index), ...columns.slice(index + 1)];
};
const insert = ({
  column,
  columns,
  defaultColumns
}) => {
  const defaultIndex = defaultColumns.findIndex(defaultColumn => defaultColumn.id === column.id);
  const isInDefaultConfig = defaultIndex >= 0;

  // if the column isn't shown but it's part of the default config
  // insert into the same position as in the default config
  if (isInDefaultConfig) {
    return [...columns.slice(0, defaultIndex), column, ...columns.slice(defaultIndex)];
  }
  if (columns.length === 0) {
    return [column];
  }

  // if the column isn't shown and it's not part of the default config
  // push it into the second position. Behaviour copied by t_grid, security
  // does this to insert right after the timestamp column
  return [columns[0], column, ...columns.slice(1)];
};
const formatSystemColumn = column => {
  const newColumn = {
    ...column
  };
  if (newColumn.id === _ruleDataUtils.ALERT_CASE_IDS) {
    newColumn.isSortable = false;

    /**
     * If a solution wants to default the case column and set their own
     * display text we should not modified it. For that reason,
     * we check if the displayAsText is set.
     */
    if (!newColumn.displayAsText) {
      newColumn.displayAsText = i18n.CASES;
    }
  }
  if (newColumn.id === _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS) {
    newColumn.isSortable = false;
    if (!newColumn.displayAsText) {
      newColumn.displayAsText = i18n.MAINTENANCE_WINDOWS;
    }
  }
  return newColumn;
};

/**
 * @param param.column column to be removed/inserted
 * @param param.columns current array of columns in the grid
 * @param param.defaultColumns Initial columns set up in the configuration before being modified by the user
 * @returns the new list of columns
 */
const toggleColumn = ({
  column,
  columns,
  defaultColumns
}) => {
  const currentIndex = columns.findIndex(currentColumn => currentColumn.id === column.id);
  const isVisible = currentIndex >= 0;

  /**
   * For the Cases column we want to change the
   * label of the column from kibana.alert.case_ids to Cases.
   */
  const formattedColumn = formatSystemColumn(column);
  if (isVisible) {
    return remove({
      columns,
      index: currentIndex
    });
  }
  return insert({
    defaultColumns,
    column: formattedColumn,
    columns
  });
};
exports.toggleColumn = toggleColumn;