"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkUntrackAlertsByQuery = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _alerts_table_context = require("../contexts/alerts_table_context");
var _common2 = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkUntrackAlertsByQuery = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _common2.useKibana)().services;
  const untrackAlertsByQuery = (0, _reactQuery.useMutation)(['untrackAlerts'], ({
    query,
    featureIds
  }) => {
    try {
      const body = JSON.stringify({
        query: Array.isArray(query) ? query : [query],
        feature_ids: featureIds
      });
      return http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/alerts/_bulk_untrack_by_query`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to parse bulk untrack by query params: ${e}`);
    }
  }, {
    context: _alerts_table_context.AlertsTableQueryContext,
    onError: () => {
      toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.untrackByQuery.failedMessage', {
        defaultMessage: 'Failed to untrack alerts by query'
      }));
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.untrackByQuery.successMessage', {
        defaultMessage: 'Untracked alerts'
      }));
    }
  });
  return untrackAlertsByQuery;
};
exports.useBulkUntrackAlertsByQuery = useBulkUntrackAlertsByQuery;