"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityFeatureIds = exports.observabilityApps = exports.alertProducersData = exports._ = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const observabilityFeatureIds = exports.observabilityFeatureIds = [_ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.UPTIME, _ruleDataUtils.AlertConsumers.MONITORING];
const [_, ...observabilityApps] = observabilityFeatureIds;
exports.observabilityApps = observabilityApps;
exports._ = _;
const alertProducersData = exports.alertProducersData = {
  [_ruleDataUtils.AlertConsumers.OBSERVABILITY]: {
    displayName: _translations.OBSERVABILITY_DISPLAY_NAME,
    icon: 'logoObservability',
    subFeatureIds: observabilityFeatureIds
  },
  [_ruleDataUtils.AlertConsumers.APM]: {
    displayName: _translations.APM_DISPLAY_NAME,
    icon: 'apmApp'
  },
  [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE]: {
    displayName: _translations.INFRASTRUCTURE_DISPLAY_NAME,
    icon: 'logoObservability'
  },
  [_ruleDataUtils.AlertConsumers.LOGS]: {
    displayName: _translations.LOGS_DISPLAY_NAME,
    icon: 'logsApp'
  },
  [_ruleDataUtils.AlertConsumers.SLO]: {
    displayName: _translations.SLO_DISPLAY_NAME,
    icon: 'logoObservability'
  },
  [_ruleDataUtils.AlertConsumers.UPTIME]: {
    displayName: _translations.UPTIME_DISPLAY_NAME,
    icon: 'uptimeApp'
  },
  [_ruleDataUtils.AlertConsumers.MONITORING]: {
    displayName: _translations.STACK_MONITORING_DISPLAY_NAME,
    icon: 'monitoringApp'
  },
  [_ruleDataUtils.AlertConsumers.ML]: {
    displayName: _translations.ML_DISPLAY_NAME,
    icon: 'machineLearningApp'
  },
  [_ruleDataUtils.AlertConsumers.SIEM]: {
    displayName: _translations.SECURITY_DISPLAY_NAME,
    icon: 'logoSecurity'
  },
  [_ruleDataUtils.AlertConsumers.STACK_ALERTS]: {
    displayName: _translations.STACK_MANAGEMENT_DISPLAY_NAME,
    icon: 'managementApp'
  },
  [_ruleDataUtils.AlertConsumers.EXAMPLE]: {
    displayName: 'Example',
    icon: 'beaker'
  }
};