"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGenericAlertsTableConfigurations = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
var _default_alerts_flyout = require("./alerts_flyout/default_alerts_flyout");
var _alert_actions_cell = require("./row_actions/alert_actions_cell");
var _render_cell_value = require("./cells/render_cell_value");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.statusColumnDescription', {
    defaultMessage: 'Alert Status'
  }),
  id: _ruleDataUtils.ALERT_STATUS,
  initialWidth: 120
}, {
  displayAsText: _translations.FEATURE_LABEL,
  id: _ruleDataUtils.ALERT_RULE_CONSUMER,
  schema: 'string',
  initialWidth: 180
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.lastUpdatedColumnDescription', {
    defaultMessage: 'Last updated'
  }),
  id: _ruleDataUtils.TIMESTAMP,
  initialWidth: 200,
  schema: 'datetime'
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.startedColumnDescription', {
    defaultMessage: 'Started'
  }),
  id: _ruleDataUtils.ALERT_START,
  initialWidth: 200,
  schema: 'datetime'
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.ruleCategoryColumnDescription', {
    defaultMessage: 'Rule category'
  }),
  id: _ruleDataUtils.ALERT_RULE_CATEGORY,
  initialWidth: 160
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.ruleColumnDescription', {
    defaultMessage: 'Rule'
  }),
  id: _ruleDataUtils.ALERT_RULE_NAME,
  initialWidth: 230
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.ruleTagsColumnDescription', {
    defaultMessage: 'Rule tags'
  }),
  id: _ruleDataUtils.ALERT_RULE_TAGS,
  initialWidth: 120
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.evaluationValuesColumnDescription', {
    defaultMessage: 'Evaluation values'
  }),
  id: _ruleDataUtils.ALERT_EVALUATION_VALUES,
  initialWidth: 120
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.evaluationThresholdColumnDescription', {
    defaultMessage: 'Evaluation threshold'
  }),
  id: _ruleDataUtils.ALERT_EVALUATION_THRESHOLD,
  initialWidth: 120
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.reasonColumnDescription', {
    defaultMessage: 'Reason'
  }),
  id: _ruleDataUtils.ALERT_REASON,
  linkField: '*',
  initialWidth: 260
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.maintenanceWindowsColumnDescription', {
    defaultMessage: 'Maintenance windows'
  }),
  id: _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS,
  schema: 'string',
  initialWidth: 180
}];
const sort = [{
  [_ruleDataUtils.TIMESTAMP]: {
    order: 'desc'
  }
}];
const useActionsColumn = () => ({
  renderCustomActionsRow: props => {
    return /*#__PURE__*/_react.default.createElement(_alert_actions_cell.AlertActionsCell, props);
  }
});
const createGenericAlertsTableConfigurations = fieldFormats => {
  const [firstColumn, _, ...genericColumns] = columns;
  return [{
    id: _constants.ALERT_TABLE_GENERIC_CONFIG_ID,
    columns: [firstColumn, ...genericColumns],
    getRenderCellValue: _render_cell_value.getRenderCellValue,
    useInternalFlyout: (0, _default_alerts_flyout.getDefaultAlertFlyout)(columns, (0, _render_cell_value.getAlertFormatters)(fieldFormats)),
    sort,
    useActionsColumn
  }, {
    id: _constants.ALERT_TABLE_GLOBAL_CONFIG_ID,
    columns,
    getRenderCellValue: _render_cell_value.getRenderCellValue,
    useInternalFlyout: (0, _default_alerts_flyout.getDefaultAlertFlyout)(columns, (0, _render_cell_value.getAlertFormatters)(fieldFormats)),
    sort,
    useActionsColumn
  }];
};
exports.createGenericAlertsTableConfigurations = createGenericAlertsTableConfigurations;