"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFormatters = getAlertFormatters;
exports.getRenderCellValue = exports.getMappedNonEcsValue = exports.getFieldFormatterProvider = void 0;
exports.useFieldFormatter = useFieldFormatter;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/field-formats-plugin/common");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappedNonEcsValue = ({
  data,
  fieldName
}) => {
  const item = data.find(d => d.field === fieldName);
  if (item != null && item.value != null) {
    return item.value;
  }
  return undefined;
};
exports.getMappedNonEcsValue = getMappedNonEcsValue;
const getRenderValue = mappedNonEcsValue => {
  const value = Array.isArray(mappedNonEcsValue) ? mappedNonEcsValue.join() : mappedNonEcsValue;
  if (!(0, _lodash.isEmpty)(value)) {
    if (typeof value === 'object') {
      return JSON.stringify(value);
    }
    return value;
  }
  return '—';
};
const getRenderCellValue = ({
  columnId,
  data,
  fieldFormats
}) => {
  const alertValueFormatter = getAlertFormatters(fieldFormats);
  if (data == null) return null;
  const mappedNonEcsValue = getMappedNonEcsValue({
    data,
    fieldName: columnId
  });
  const value = getRenderValue(mappedNonEcsValue);
  return alertValueFormatter(columnId, value, data);
};
exports.getRenderCellValue = getRenderCellValue;
const defaultParam = {
  [_common.FIELD_FORMAT_IDS.DURATION]: {
    inputFormat: 'milliseconds',
    outputFormat: 'humanizePrecise'
  },
  [_common.FIELD_FORMAT_IDS.NUMBER]: {
    pattern: '00.00'
  }
};
const getFieldFormatterProvider = fieldFormats => (fieldType, params) => {
  const fieldFormatter = fieldFormats.deserialize({
    id: fieldType,
    params: params !== null && params !== void 0 ? params : defaultParam[fieldType]
  });
  return fieldFormatter.convert.bind(fieldFormatter);
};
exports.getFieldFormatterProvider = getFieldFormatterProvider;
function useFieldFormatter(fieldType) {
  const {
    fieldFormats
  } = (0, _kibana.useKibana)().services;
  return getFieldFormatterProvider(fieldFormats)(fieldType);
}
const AlertRuleLink = ({
  alertFields
}) => {
  var _alertFields$find, _alertFields$find$val, _alertFields$find2, _alertFields$find2$va;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const ruleName = (_alertFields$find = alertFields.find(f => f.field === _ruleDataUtils.ALERT_RULE_NAME)) === null || _alertFields$find === void 0 ? void 0 : (_alertFields$find$val = _alertFields$find.value) === null || _alertFields$find$val === void 0 ? void 0 : _alertFields$find$val[0];
  const ruleUuid = (_alertFields$find2 = alertFields.find(f => f.field === _ruleDataUtils.ALERT_RULE_UUID)) === null || _alertFields$find2 === void 0 ? void 0 : (_alertFields$find2$va = _alertFields$find2.value) === null || _alertFields$find2$va === void 0 ? void 0 : _alertFields$find2$va[0];
  if (!ruleName || !ruleUuid) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(`/app/management/insightsAndAlerting/triggersActions/rule/${ruleUuid}`)
  }, ruleName);
};
function getAlertFormatters(fieldFormats) {
  const getFormatter = getFieldFormatterProvider(fieldFormats);
  return (columnId, value, rowData) => {
    var _rowData$find, _rowData$find$value;
    switch (columnId) {
      case _ruleDataUtils.TIMESTAMP:
      case _ruleDataUtils.ALERT_START:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DATE)(value));
      case _ruleDataUtils.ALERT_RULE_NAME:
        return rowData ? /*#__PURE__*/_react.default.createElement(AlertRuleLink, {
          alertFields: rowData
        }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
      case _ruleDataUtils.ALERT_DURATION:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getFormatter(_common.FIELD_FORMAT_IDS.DURATION, {
          inputFormat: 'microseconds',
          outputFormat: 'humanizePrecise'
        })(value) || '--');
      case _ruleDataUtils.ALERT_RULE_CONSUMER:
        const producer = rowData === null || rowData === void 0 ? void 0 : (_rowData$find = rowData.find(({
          field
        }) => field === _ruleDataUtils.ALERT_RULE_PRODUCER)) === null || _rowData$find === void 0 ? void 0 : (_rowData$find$value = _rowData$find.value) === null || _rowData$find$value === void 0 ? void 0 : _rowData$find$value[0];
        const consumer = _constants.observabilityFeatureIds.includes(producer) ? 'observability' : producer && (value === 'alerts' || value === 'stackAlerts') ? producer : value;
        const consumerData = _constants.alertProducersData[consumer];
        if (!consumerData) {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          iconType: consumerData.icon
        }, consumerData.displayName);
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
    }
  };
}