"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertLifecycleStatusCell = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _alert_lifecycle_status_badge = require("../../../components/alert_lifecycle_status_badge");
var _default_cell = require("./default_cell");
var _use_alert_muted_state = require("../hooks/alert_mute/use_alert_muted_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mutedBadgeStyle = (0, _react2.css)`
  padding-inline: ${_uiTheme.euiThemeVars.euiSizeXS};
`;
const AlertLifecycleStatusCellComponent = props => {
  var _ref;
  const {
    alert,
    showAlertStatusWithFlapping
  } = props;
  const {
    isMuted
  } = (0, _use_alert_muted_state.useAlertMutedState)(alert);
  if (!showAlertStatusWithFlapping) {
    return null;
  }
  const alertStatus = (_ref = alert && alert[_ruleDataUtils.ALERT_STATUS]) !== null && _ref !== void 0 ? _ref : [];
  if (Array.isArray(alertStatus) && alertStatus.length) {
    var _ref2;
    const flapping = (_ref2 = alert && alert[_ruleDataUtils.ALERT_FLAPPING]) !== null && _ref2 !== void 0 ? _ref2 : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
      alertStatus: alertStatus.join(),
      flapping: flapping[0]
    }), isMuted && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertMuted', {
        defaultMessage: 'Alert muted'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "bellSlash",
      css: mutedBadgeStyle
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_default_cell.DefaultCell, props);
};
AlertLifecycleStatusCellComponent.displayName = 'AlertLifecycleStatusCell';
const AlertLifecycleStatusCell = exports.AlertLifecycleStatusCell = /*#__PURE__*/(0, _react.memo)(AlertLifecycleStatusCellComponent);