"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _casesComponents = require("@kbn/cases-components");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_case_view_navigation = require("./use_case_view_navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatCase = theCase => {
  var _theCase$created_by$u, _theCase$created_by$f;
  return {
    title: theCase.title,
    description: theCase.description,
    createdAt: theCase.created_at,
    createdBy: {
      username: (_theCase$created_by$u = theCase.created_by.username) !== null && _theCase$created_by$u !== void 0 ? _theCase$created_by$u : undefined,
      fullName: (_theCase$created_by$f = theCase.created_by.full_name) !== null && _theCase$created_by$f !== void 0 ? _theCase$created_by$f : undefined
    },
    status: theCase.status,
    totalComments: theCase.totalComment
  };
};
const CasesCellComponent = props => {
  var _ref;
  const {
    isLoading,
    alert,
    cases,
    caseAppId
  } = props;
  const {
    navigateToCaseView
  } = (0, _use_case_view_navigation.useCaseViewNavigation)(caseAppId);
  const caseIds = (_ref = alert && alert[_ruleDataUtils.ALERT_CASE_IDS]) !== null && _ref !== void 0 ? _ref : [];
  const validCases = caseIds.map(id => cases.get(id)).filter(theCase => theCase != null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    isLoading: isLoading,
    size: "s",
    "data-test-subj": "cases-cell-loading"
  }, validCases.length !== 0 ? validCases.map((theCase, index) => [index > 0 && index < validCases.length && ', ', /*#__PURE__*/_react.default.createElement(_casesComponents.Tooltip, {
    loading: false,
    content: formatCase(theCase),
    key: theCase.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => navigateToCaseView({
      caseId: theCase.id
    }),
    "data-test-subj": "cases-cell-link"
  }, theCase.title))]) : '--');
};
CasesCellComponent.displayName = 'CasesCell';
const CasesCell = exports.CasesCell = /*#__PURE__*/(0, _react.memo)(CasesCellComponent);