"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionsRowCell = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../translations");
var _alerts_table_context = require("../../contexts/alerts_table_context");
var _types = require("../../../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkActionsRowCellComponent = ({
  rowIndex
}) => {
  var _rowSelection$get;
  const {
    bulkActions: [{
      rowSelection
    }, updateSelectedRows]
  } = (0, _react.useContext)(_alerts_table_context.AlertsTableContext);
  const isChecked = rowSelection.has(rowIndex);
  const isLoading = isChecked && ((_rowSelection$get = rowSelection.get(rowIndex)) === null || _rowSelection$get === void 0 ? void 0 : _rowSelection$get.isLoading);
  const onChange = (0, _react.useCallback)(e => {
    if (e.target.checked) {
      updateSelectedRows({
        action: _types.BulkActionsVerbs.add,
        rowIndex
      });
    } else {
      updateSelectedRows({
        action: _types.BulkActionsVerbs.delete,
        rowIndex
      });
    }
  }, [rowIndex, updateSelectedRows]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      "data-test-subj": "row-loader"
    });
  }

  // NOTE: id is prefixed here to avoid conflicts with labels in other sections in the app.
  // see https://github.com/elastic/kibana/issues/162837

  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: `bulk-actions-row-cell-${rowIndex}`,
    "aria-label": (0, _translations.SELECT_ROW_ARIA_LABEL)(rowIndex + 1),
    checked: isChecked,
    onChange: onChange,
    "data-test-subj": "bulk-actions-row-cell"
  });
};
const BulkActionsRowCell = exports.BulkActionsRowCell = /*#__PURE__*/_react.default.memo(BulkActionsRowCellComponent);