"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsTableState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _use_get_muted_alerts = require("./hooks/alert_mute/use_get_muted_alerts");
var _use_fetch_alerts = require("./hooks/use_fetch_alerts");
var _alerts_table = require("./alerts_table");
var _empty_state = require("./empty_state");
var _translations = require("./translations");
var _reducer = require("./bulk_actions/reducer");
var _use_columns = require("./hooks/use_columns");
var _inspect = require("./toolbar/components/inspect");
var _query_client = require("./query_client");
var _use_bulk_get_cases = require("./hooks/use_bulk_get_cases");
var _use_bulk_get_maintenance_windows = require("./hooks/use_bulk_get_maintenance_windows");
var _alerts_table_context = require("./contexts/alerts_table_context");
var _error_boundary = require("../common/components/error_boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultPagination = {
  pageSize: 10,
  pageIndex: 0
};
const EmptyConfiguration = {
  id: '',
  columns: [],
  sort: [],
  getRenderCellValue: () => null
};
const getCaseIdsFromAlerts = alerts => new Set(alerts.filter(alert => {
  const caseIds = alert[_ruleDataUtils.ALERT_CASE_IDS];
  return caseIds != null && caseIds.length > 0;
}).map(alert => alert[_ruleDataUtils.ALERT_CASE_IDS]).flat());
const getMaintenanceWindowIdsFromAlerts = alerts => new Set(alerts.filter(alert => {
  const maintenanceWindowIds = alert[_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS];
  return maintenanceWindowIds != null && maintenanceWindowIds.length > 0;
}).map(alert => alert[_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]).flat());
const isCasesColumnEnabled = columns => columns.some(({
  id
}) => id === _ruleDataUtils.ALERT_CASE_IDS);
const isMaintenanceWindowColumnEnabled = columns => columns.some(({
  id
}) => id === _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS);
const stableEmptyArray = [];
const defaultPageSizeOptions = [10, 20, 50, 100];
const emptyRowSelection = new Map();
const initialBulkActionsState = {
  rowSelection: emptyRowSelection,
  isAllSelected: false,
  areAllVisibleRowsSelected: false,
  rowCount: 0,
  updatedAt: Date.now()
};
const ErrorBoundaryFallback = ({
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.ALERTS_TABLE_UNKNOWN_ERROR_TITLE),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _translations.ALERTS_TABLE_UNKNOWN_ERROR_MESSAGE), error.message && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.message)),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: [error.message, error.stack].filter(Boolean).join('\n')
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: copy,
      color: "danger",
      fill: true
    }, _translations.ALERTS_TABLE_UNKNOWN_ERROR_COPY_TO_CLIPBOARD_LABEL))
  });
};
const AlertsTableState = exports.default = exports.AlertsTableState = /*#__PURE__*/(0, _react.memo)(props => {
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.alertsTableQueryClient,
    context: _alerts_table_context.AlertsTableQueryContext
  }, /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, {
    fallback: ErrorBoundaryFallback
  }, /*#__PURE__*/_react.default.createElement(AlertsTableStateWithQueryProvider, props)));
});
AlertsTableState.displayName = 'AlertsTableState';
const DEFAULT_LEADING_CONTROL_COLUMNS = [];
const AlertsTableStateWithQueryProvider = /*#__PURE__*/(0, _react.memo)(({
  alertsTableConfigurationRegistry,
  configurationId,
  id,
  featureIds,
  query,
  pageSize,
  leadingControlColumns = DEFAULT_LEADING_CONTROL_COLUMNS,
  trailingControlColumns,
  rowHeightsOptions,
  cellContext,
  columns: propColumns,
  gridStyle,
  browserFields: propBrowserFields,
  onUpdate,
  onLoaded,
  runtimeMappings,
  showAlertStatusWithFlapping,
  toolbarVisibility,
  shouldHighlightRow,
  dynamicRowHeight,
  lastReloadRequestTime
}) => {
  var _alertsTableConfigura, _alertsTableConfigura2, _alertsTableConfigura3, _alertsTableConfigura9, _alertsTableConfigura10, _alertsTableConfigura11, _alertsTableConfigura12;
  const {
    cases: casesService,
    fieldFormats
  } = (0, _public2.useKibana)().services;
  const hasAlertsTableConfiguration = (_alertsTableConfigura = alertsTableConfigurationRegistry === null || alertsTableConfigurationRegistry === void 0 ? void 0 : alertsTableConfigurationRegistry.has(configurationId)) !== null && _alertsTableConfigura !== void 0 ? _alertsTableConfigura : false;
  if (!hasAlertsTableConfiguration)
    // eslint-disable-next-line no-console
    console.warn(`Missing Alert Table configuration for configuration ID: ${configurationId}`);
  const alertsTableConfiguration = hasAlertsTableConfiguration ? alertsTableConfigurationRegistry.get(configurationId) : EmptyConfiguration;
  const storage = (0, _react.useRef)(new _public.Storage(window.localStorage));
  const localStorageAlertsTableConfig = storage.current.get(id);
  const persistentControls = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : (_alertsTableConfigura2 = alertsTableConfiguration.usePersistentControls) === null || _alertsTableConfigura2 === void 0 ? void 0 : _alertsTableConfigura2.call(alertsTableConfiguration);
  const showInspectButton = (_alertsTableConfigura3 = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : alertsTableConfiguration.showInspectButton) !== null && _alertsTableConfigura3 !== void 0 ? _alertsTableConfigura3 : false;
  const columnConfigByClient = (0, _react.useMemo)(() => {
    var _alertsTableConfigura4;
    return propColumns && !(0, _lodash.isEmpty)(propColumns) ? propColumns : (_alertsTableConfigura4 = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : alertsTableConfiguration.columns) !== null && _alertsTableConfigura4 !== void 0 ? _alertsTableConfigura4 : [];
  }, [propColumns, alertsTableConfiguration]);
  const columnsLocal = localStorageAlertsTableConfig && localStorageAlertsTableConfig.columns && !(0, _lodash.isEmpty)(localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.columns) ? localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.columns : columnConfigByClient;
  const getStorageConfig = (0, _react.useCallback)(() => {
    var _alertsTableConfigura5;
    return {
      columns: columnsLocal,
      sort: localStorageAlertsTableConfig && localStorageAlertsTableConfig.sort && !(0, _lodash.isEmpty)(localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.sort) ? localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.sort : (_alertsTableConfigura5 = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : alertsTableConfiguration.sort) !== null && _alertsTableConfigura5 !== void 0 ? _alertsTableConfigura5 : [],
      visibleColumns: localStorageAlertsTableConfig && localStorageAlertsTableConfig.visibleColumns && !(0, _lodash.isEmpty)(localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.visibleColumns) ? localStorageAlertsTableConfig === null || localStorageAlertsTableConfig === void 0 ? void 0 : localStorageAlertsTableConfig.visibleColumns : columnsLocal.map(c => c.id)
    };
  }, [columnsLocal, alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : alertsTableConfiguration.sort, localStorageAlertsTableConfig]);
  const storageAlertsTable = (0, _react.useRef)(getStorageConfig());
  storageAlertsTable.current = getStorageConfig();
  const [sort, setSort] = (0, _react.useState)(storageAlertsTable.current.sort);
  const [pagination, setPagination] = (0, _react.useState)({
    ...DefaultPagination,
    pageSize: pageSize !== null && pageSize !== void 0 ? pageSize : DefaultPagination.pageSize
  });
  const onPageChange = (0, _react.useCallback)(_pagination => {
    setPagination(_pagination);
  }, []);
  const {
    columns,
    browserFields,
    isBrowserFieldDataLoading,
    onToggleColumn,
    onResetColumns,
    visibleColumns,
    onChangeVisibleColumns,
    onColumnResize,
    fields
  } = (0, _use_columns.useColumns)({
    featureIds,
    storageAlertsTable,
    storage,
    id,
    defaultColumns: columnConfigByClient,
    initialBrowserFields: propBrowserFields
  });
  const [isLoading, {
    alerts,
    oldAlertsData,
    ecsAlertsData,
    isInitializing,
    getInspectQuery,
    refetch: refresh,
    totalAlerts: alertsCount
  }] = (0, _use_fetch_alerts.useFetchAlerts)({
    fields,
    featureIds,
    query,
    pagination,
    onPageChange,
    onLoaded,
    runtimeMappings,
    sort,
    skip: false
  });
  const mutedAlertIds = (0, _react.useMemo)(() => {
    return [...new Set(alerts.map(a => a['kibana.alert.rule.uuid'][0]))];
  }, [alerts]);
  const {
    data: mutedAlerts
  } = (0, _use_get_muted_alerts.useGetMutedAlerts)(mutedAlertIds);
  const overriddenActions = (0, _react.useMemo)(() => {
    return {
      toggleColumn: onToggleColumn
    };
  }, [onToggleColumn]);
  const configWithToggle = (0, _react.useMemo)(() => {
    return {
      ...alertsTableConfiguration,
      actions: overriddenActions
    };
  }, [alertsTableConfiguration, overriddenActions]);
  (0, _react.useEffect)(() => {
    var _alertsTableConfigura6;
    const currentToggle = (_alertsTableConfigura6 = alertsTableConfigurationRegistry.getActions(configurationId)) === null || _alertsTableConfigura6 === void 0 ? void 0 : _alertsTableConfigura6.toggleColumn;
    if (onToggleColumn !== currentToggle) {
      alertsTableConfigurationRegistry.update(configurationId, configWithToggle);
    }
  }, [configurationId, alertsTableConfigurationRegistry, configWithToggle, onToggleColumn]);
  (0, _react.useEffect)(() => {
    if (onUpdate) {
      onUpdate({
        isLoading,
        totalCount: alertsCount,
        refresh
      });
    }
  }, [isLoading, alertsCount, onUpdate, refresh]);
  (0, _react.useEffect)(() => {
    if (lastReloadRequestTime) {
      refresh();
    }
  }, [lastReloadRequestTime, refresh]);
  const caseIds = (0, _react.useMemo)(() => getCaseIdsFromAlerts(alerts), [alerts]);
  const maintenanceWindowIds = (0, _react.useMemo)(() => getMaintenanceWindowIdsFromAlerts(alerts), [alerts]);
  const casesPermissions = (0, _react.useMemo)(() => {
    var _alertsTableConfigura7, _alertsTableConfigura8;
    return casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases((_alertsTableConfigura7 = alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : (_alertsTableConfigura8 = alertsTableConfiguration.cases) === null || _alertsTableConfigura8 === void 0 ? void 0 : _alertsTableConfigura8.owner) !== null && _alertsTableConfigura7 !== void 0 ? _alertsTableConfigura7 : []);
  }, [alertsTableConfiguration, casesService]);
  const hasCaseReadPermissions = Boolean(casesPermissions === null || casesPermissions === void 0 ? void 0 : casesPermissions.read);
  const fetchCases = isCasesColumnEnabled(columns) && hasCaseReadPermissions;
  const fetchMaintenanceWindows = isMaintenanceWindowColumnEnabled(columns);
  const caseIdsForBulk = (0, _react.useMemo)(() => {
    return Array.from(caseIds.values());
  }, [caseIds]);
  const {
    data: cases,
    isFetching: isLoadingCases
  } = (0, _use_bulk_get_cases.useBulkGetCases)(caseIdsForBulk, fetchCases);
  const maintenanceWindowIdsForBulk = (0, _react.useMemo)(() => {
    return {
      ids: Array.from(maintenanceWindowIds.values()),
      canFetchMaintenanceWindows: fetchMaintenanceWindows,
      queryContext: _alerts_table_context.AlertsTableQueryContext
    };
  }, [fetchMaintenanceWindows, maintenanceWindowIds]);
  const {
    data: maintenanceWindows,
    isFetching: isLoadingMaintenanceWindows
  } = (0, _use_bulk_get_maintenance_windows.useBulkGetMaintenanceWindows)(maintenanceWindowIdsForBulk);
  const activeBulkActionsReducer = (0, _react.useReducer)(_reducer.bulkActionsReducer, initialBulkActionsState);
  const onSortChange = (0, _react.useCallback)(_sort => {
    const newSort = _sort.map(sortItem => {
      return {
        [sortItem.id]: {
          order: sortItem.direction
        }
      };
    });
    storageAlertsTable.current = {
      ...storageAlertsTable.current,
      sort: newSort
    };
    storage.current.set(id, storageAlertsTable.current);
    setSort(newSort);
  }, [id]);
  const CasesContext = (0, _react.useMemo)(() => {
    return casesService === null || casesService === void 0 ? void 0 : casesService.ui.getCasesContext();
  }, [casesService === null || casesService === void 0 ? void 0 : casesService.ui]);
  const isCasesContextAvailable = casesService && CasesContext;
  const memoizedCases = (0, _react.useMemo)(() => ({
    data: cases !== null && cases !== void 0 ? cases : new Map(),
    isLoading: isLoadingCases
  }), [cases, isLoadingCases]);
  const memoizedMaintenanceWindows = (0, _react.useMemo)(() => ({
    data: maintenanceWindows !== null && maintenanceWindows !== void 0 ? maintenanceWindows : new Map(),
    isLoading: isLoadingMaintenanceWindows
  }), [maintenanceWindows, isLoadingMaintenanceWindows]);
  const tableProps = (0, _react.useMemo)(() => ({
    alertsTableConfiguration,
    cases: memoizedCases,
    maintenanceWindows: memoizedMaintenanceWindows,
    columns,
    bulkActions: stableEmptyArray,
    deletedEventIds: stableEmptyArray,
    disabledCellActions: stableEmptyArray,
    pageSizeOptions: defaultPageSizeOptions,
    id,
    leadingControlColumns,
    showAlertStatusWithFlapping,
    trailingControlColumns,
    visibleColumns,
    'data-test-subj': 'internalAlertsState',
    browserFields,
    onToggleColumn,
    onResetColumns,
    onChangeVisibleColumns,
    onColumnResize,
    query,
    rowHeightsOptions,
    cellContext,
    gridStyle,
    controls: persistentControls,
    showInspectButton,
    toolbarVisibility,
    shouldHighlightRow,
    dynamicRowHeight,
    featureIds,
    isInitializing,
    pagination,
    sort,
    isLoading,
    alerts,
    oldAlertsData,
    ecsAlertsData,
    getInspectQuery,
    refetch: refresh,
    alertsCount,
    onSortChange,
    onPageChange,
    fieldFormats
  }), [alertsTableConfiguration, memoizedCases, memoizedMaintenanceWindows, columns, id, leadingControlColumns, trailingControlColumns, showAlertStatusWithFlapping, visibleColumns, browserFields, onToggleColumn, onResetColumns, onChangeVisibleColumns, onColumnResize, query, rowHeightsOptions, gridStyle, persistentControls, showInspectButton, toolbarVisibility, shouldHighlightRow, dynamicRowHeight, featureIds, cellContext, isInitializing, pagination, sort, isLoading, alerts, oldAlertsData, ecsAlertsData, getInspectQuery, refresh, alertsCount, onSortChange, onPageChange, fieldFormats]);
  const alertsTableContext = (0, _react.useMemo)(() => {
    return {
      mutedAlerts: mutedAlerts !== null && mutedAlerts !== void 0 ? mutedAlerts : {},
      bulkActions: activeBulkActionsReducer
    };
  }, [activeBulkActionsReducer, mutedAlerts]);
  return hasAlertsTableConfiguration ? /*#__PURE__*/_react.default.createElement(_alerts_table_context.AlertsTableContext.Provider, {
    value: alertsTableContext
  }, !isLoading && alertsCount === 0 && /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
    controls: persistentControls,
    getInspectQuery: getInspectQuery,
    showInpectButton: showInspectButton
  })), (isLoading || isBrowserFieldDataLoading) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    "data-test-subj": "internalAlertsPageLoading"
  }), alertsCount !== 0 && isCasesContextAvailable && /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: (_alertsTableConfigura9 = (_alertsTableConfigura10 = alertsTableConfiguration.cases) === null || _alertsTableConfigura10 === void 0 ? void 0 : _alertsTableConfigura10.owner) !== null && _alertsTableConfigura9 !== void 0 ? _alertsTableConfigura9 : [],
    permissions: casesPermissions,
    features: {
      alerts: {
        sync: (_alertsTableConfigura11 = (_alertsTableConfigura12 = alertsTableConfiguration.cases) === null || _alertsTableConfigura12 === void 0 ? void 0 : _alertsTableConfigura12.syncAlerts) !== null && _alertsTableConfigura11 !== void 0 ? _alertsTableConfigura11 : false
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, tableProps)), alertsCount !== 0 && !isCasesContextAvailable && /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, tableProps)) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "alertsTableNoConfiguration",
    iconType: "watchesApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.ALERTS_TABLE_CONF_ERROR_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, _translations.ALERTS_TABLE_CONF_ERROR_MESSAGE)
  });
});
AlertsTableStateWithQueryProvider.displayName = 'AlertsTableStateWithQueryProvider';

// eslint-disable-next-line import/no-default-export