"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _hooks = require("./hooks");
var _translations = require("./translations");
require("./alerts_table.scss");
var _toolbar = require("./toolbar");
var _inspect = require("./toolbar/components/inspect");
var _cells = require("./cells");
var _constants = require("../../hooks/constants");
var _alerts_table_context = require("./contexts/alerts_table_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsFlyout = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./alerts_flyout'))));
const DefaultGridStyle = {
  border: 'none',
  header: 'underline',
  fontSize: 's'
};
const getCellActionsStub = {
  getCellActions: () => null,
  visibleCellActions: undefined,
  disabledCellActions: []
};
const fieldBrowserStub = () => ({});
const stableMappedRowClasses = {};
const BasicRenderCellValue = /*#__PURE__*/(0, _react.memo)(({
  data,
  columnId
}) => {
  var _ref, _data$find;
  const value = (_ref = Array.isArray(data) && ((_data$find = data.find(d => d.field === columnId)) === null || _data$find === void 0 ? void 0 : _data$find.value)) !== null && _ref !== void 0 ? _ref : [];
  if (Array.isArray(value)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.length ? value.join() : '--');
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
});
const FullFeaturedRenderCellValue = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    columnId,
    cases,
    maintenanceWindows,
    showAlertStatusWithFlapping,
    isLoading,
    isLoadingCases,
    isLoadingMaintenanceWindows,
    casesConfig,
    rowIndex,
    pagination,
    RenderCell,
    ecsData,
    alerts
  } = props;
  const idx = rowIndex - pagination.pageSize * pagination.pageIndex;
  const alert = alerts[idx];
  if (isSystemCell(columnId)) {
    return /*#__PURE__*/_react.default.createElement(_cells.SystemCellFactory, {
      alert: alert,
      columnId: columnId,
      isLoading: isLoading || isLoadingCases || isLoadingMaintenanceWindows,
      cases: cases,
      maintenanceWindows: maintenanceWindows,
      showAlertStatusWithFlapping: showAlertStatusWithFlapping,
      caseAppId: casesConfig === null || casesConfig === void 0 ? void 0 : casesConfig.appId
    });
  } else if (alert) {
    // ecsAlert is needed for security solution
    const ecsAlert = ecsData[idx];
    const data = [];
    Object.entries(alert !== null && alert !== void 0 ? alert : {}).forEach(([key, value]) => {
      data.push({
        field: key,
        value: value
      });
    });
    if (RenderCell && ecsAlert) {
      return /*#__PURE__*/_react.default.createElement(RenderCell, (0, _extends2.default)({}, props, {
        data: data,
        ecsData: ecsAlert
      }));
    } else {
      return /*#__PURE__*/_react.default.createElement(BasicRenderCellValue, {
        data: data,
        columnId: columnId
      });
    }
  } else if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  return null;
});
const ControlColumnHeaderRenderCell = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "expandColumnHeaderLabel"
  }, _translations.ALERTS_TABLE_CONTROL_COLUMNS_ACTIONS_LABEL);
});
const ControlColumnRowRenderCell = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    visibleRowIndex,
    alerts,
    ecsData,
    setFlyoutAlert,
    oldAlertsData,
    id,
    getSetIsActionLoadingCallback,
    refresh,
    clearSelection,
    renderCustomActionsRow
  } = props;
  if (!ecsData[visibleRowIndex]) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, renderCustomActionsRow({
    alert: alerts[visibleRowIndex],
    ecsAlert: ecsData[visibleRowIndex],
    nonEcsData: oldAlertsData[visibleRowIndex],
    rowIndex: visibleRowIndex,
    setFlyoutAlert,
    id,
    cveProps: props,
    setIsActionLoading: getSetIsActionLoadingCallback(visibleRowIndex),
    refresh,
    clearSelection
  }));
});
const isSystemCell = columnId => {
  return _cells.systemCells.includes(columnId);
};
const useFieldBrowserOptionsOrDefault = (useFieldBrowserOptions, onToggleColumn) => {
  const args = (0, _react.useMemo)(() => ({
    onToggleColumn
  }), [onToggleColumn]);
  return useFieldBrowserOptions(args);
};

// Here we force the error callout to be the same height as the cell content
// so that the error detail gets hidden in the overflow area and only shown in
// the cell popover
const errorCalloutStyles = (0, _react2.css)`
  height: 1lh;
`;

/**
 * An error callout that displays the error stack in a code block
 */
const ViewError = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  alignItems: "center",
  css: errorCalloutStyles
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "error",
  color: "danger"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "xs",
  css: (0, _react2.css)`
            line-height: unset;
          `
}, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.triggersActionsUI.sections.alertTable.viewError",
  defaultMessage: "An error occurred"
}))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  isCopyable: true
}, error.stack));
const Row = _styled.default.div`
  display: flex;
  min-width: fit-content;
`;
const CustomGridBody = /*#__PURE__*/(0, _react.memo)(({
  alertsData,
  isLoading,
  pagination,
  actualGridStyle,
  visibleColumns,
  Cell,
  stripes
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertsData.concat(isLoading ? Array.from({
    length: pagination.pageSize - alertsData.length
  }) : []).map((_row, rowIndex) => {
    var _actualGridStyle$rowC, _actualGridStyle$rowC2;
    return /*#__PURE__*/_react.default.createElement(Row, {
      role: "row",
      key: `${rowIndex},${pagination.pageIndex}`
      // manually add stripes if props.gridStyle.stripes is true because presence of rowClasses
      // overrides the props.gridStyle.stripes option. And rowClasses will always be there.
      // Adding stripes only on even rows. It will be replaced by alertsTableHighlightedRow if
      // shouldHighlightRow is correct
      ,
      className: `euiDataGridRow ${stripes && rowIndex % 2 !== 0 ? 'euiDataGridRow--striped' : ''} ${(_actualGridStyle$rowC = (_actualGridStyle$rowC2 = actualGridStyle.rowClasses) === null || _actualGridStyle$rowC2 === void 0 ? void 0 : _actualGridStyle$rowC2[rowIndex]) !== null && _actualGridStyle$rowC !== void 0 ? _actualGridStyle$rowC : ''}`
    }, visibleColumns.map((_col, colIndex) => /*#__PURE__*/_react.default.createElement(Cell, {
      colIndex: colIndex,
      visibleRowIndex: rowIndex,
      key: `${rowIndex},${colIndex}`
    })));
  }));
});
const AlertsTable = exports.default = exports.AlertsTable = /*#__PURE__*/(0, _react.memo)(props => {
  var _alertsTableConfigura, _alertsTableConfigura2, _props$gridStyle4;
  const {
    visibleColumns,
    onToggleColumn,
    onResetColumns,
    browserFields,
    onChangeVisibleColumns,
    onColumnResize,
    showAlertStatusWithFlapping = false,
    showInspectButton = false,
    cellContext: passedCellContext,
    leadingControlColumns: passedControlColumns,
    trailingControlColumns,
    alertsTableConfiguration,
    pagination,
    columns,
    alerts,
    alertsCount,
    isLoading,
    oldAlertsData,
    ecsAlertsData,
    onSortChange,
    onPageChange,
    sort: sortingFields,
    refetch: alertsRefresh,
    getInspectQuery,
    rowHeightsOptions,
    dynamicRowHeight,
    query,
    featureIds,
    cases: {
      data: cases,
      isLoading: isLoadingCases
    },
    maintenanceWindows: {
      data: maintenanceWindows,
      isLoading: isLoadingMaintenanceWindows
    },
    controls,
    toolbarVisibility: toolbarVisibilityProp,
    shouldHighlightRow,
    fieldFormats
  } = props;
  const dataGridRef = (0, _react.useRef)(null);
  const [activeRowClasses, setActiveRowClasses] = (0, _react.useState)({});
  const queryClient = (0, _reactQuery.useQueryClient)({
    context: _alerts_table_context.AlertsTableQueryContext
  });
  const {
    sortingColumns,
    onSort
  } = (0, _hooks.useSorting)(onSortChange, visibleColumns, sortingFields);
  const {
    renderCustomActionsRow,
    actionsColumnWidth,
    getSetIsActionLoadingCallback
  } = (0, _hooks.useActionsColumn)({
    options: alertsTableConfiguration.useActionsColumn
  });
  const userAssigneeContext = (_alertsTableConfigura = alertsTableConfiguration.useFetchPageContext) === null || _alertsTableConfigura === void 0 ? void 0 : _alertsTableConfigura.call(alertsTableConfiguration, {
    alerts,
    columns
  });
  const bulkActionArgs = (0, _react.useMemo)(() => {
    return {
      alerts,
      casesConfig: alertsTableConfiguration.cases,
      query,
      useBulkActionsConfig: alertsTableConfiguration.useBulkActions,
      refresh: alertsRefresh,
      featureIds
    };
  }, [alerts, alertsTableConfiguration, query, alertsRefresh, featureIds]);
  const {
    isBulkActionsColumnActive,
    getBulkActionsLeadingControlColumn,
    bulkActionsState,
    bulkActions,
    setIsBulkActionsLoading,
    clearSelection
  } = (0, _hooks.useBulkActions)(bulkActionArgs);
  const refreshData = (0, _react.useCallback)(() => {
    alertsRefresh();
    queryClient.invalidateQueries(_constants.triggersActionsUiQueriesKeys.cases());
    queryClient.invalidateQueries(_constants.triggersActionsUiQueriesKeys.mutedAlerts());
    queryClient.invalidateQueries(_constants.triggersActionsUiQueriesKeys.maintenanceWindows());
  }, [alertsRefresh, queryClient]);
  const refresh = (0, _react.useCallback)(() => {
    refreshData();
    clearSelection();
  }, [clearSelection, refreshData]);
  const {
    pagination: updatedPagination,
    onChangePageSize,
    onChangePageIndex,
    onPaginateFlyout,
    flyoutAlertIndex,
    setFlyoutAlertIndex
  } = (0, _hooks.usePagination)({
    onPageChange,
    pageIndex: pagination.pageIndex,
    pageSize: pagination.pageSize
  });

  // TODO when every solution is using this table, we will be able to simplify it by just passing the alert index
  const handleFlyoutAlert = (0, _react.useCallback)(alertId => {
    const idx = alerts.findIndex(a => a[_ruleDataUtils.ALERT_UUID].includes(alertId));
    setFlyoutAlertIndex(idx);
  }, [alerts, setFlyoutAlertIndex]);
  const fieldBrowserOptions = useFieldBrowserOptionsOrDefault((_alertsTableConfigura2 = alertsTableConfiguration.useFieldBrowserOptions) !== null && _alertsTableConfigura2 !== void 0 ? _alertsTableConfigura2 : fieldBrowserStub, onToggleColumn);
  const toolbarVisibilityArgs = (0, _react.useMemo)(() => {
    return {
      bulkActions,
      alertsCount,
      rowSelection: bulkActionsState.rowSelection,
      alerts,
      isLoading,
      columnIds: visibleColumns,
      onToggleColumn,
      onResetColumns,
      browserFields,
      controls,
      setIsBulkActionsLoading,
      clearSelection,
      refresh,
      fieldBrowserOptions,
      getInspectQuery,
      showInspectButton,
      toolbarVisibilityProp
    };
  }, [bulkActions, alertsCount, bulkActionsState, isLoading, visibleColumns, onToggleColumn, onResetColumns, browserFields, setIsBulkActionsLoading, clearSelection, refresh, fieldBrowserOptions, getInspectQuery, showInspectButton, toolbarVisibilityProp, alerts, controls]);
  const toolbarVisibility = (0, _toolbar.useGetToolbarVisibility)(toolbarVisibilityArgs);
  const customActionsRow = (0, _react.useMemo)(() => {
    return renderCustomActionsRow ? {
      id: 'expandColumn',
      width: actionsColumnWidth,
      headerCellRender: ControlColumnHeaderRenderCell,
      rowCellRender: ControlColumnRowRenderCell
    } : undefined;
  }, [renderCustomActionsRow, actionsColumnWidth]);
  const bulkActionsColumn = (0, _react.useMemo)(() => {
    return isBulkActionsColumnActive ? getBulkActionsLeadingControlColumn() : undefined;
  }, [isBulkActionsColumnActive, getBulkActionsLeadingControlColumn]);
  const leadingControlColumns = (0, _react.useMemo)(() => {
    const controlColumns = passedControlColumns !== null && passedControlColumns !== void 0 ? passedControlColumns : [];
    const usedBulkActionsColumn = bulkActionsColumn ? [bulkActionsColumn] : [];
    const usedCustomActionsRow = customActionsRow ? [customActionsRow] : [];
    const mergedControlColumns = [...controlColumns, ...usedBulkActionsColumn, ...usedCustomActionsRow];
    if (mergedControlColumns.length) {
      return mergedControlColumns;
    } else {
      return undefined;
    }
  }, [bulkActionsColumn, customActionsRow, passedControlColumns]);
  const rowIndex = flyoutAlertIndex + pagination.pageIndex * pagination.pageSize;
  (0, _react.useEffect)(() => {
    // Row classes do not deal with visible row indices, so we need to handle page offset
    setActiveRowClasses({
      [rowIndex]: 'alertsTableActiveRow'
    });
  }, [rowIndex]);
  const handleFlyoutClose = (0, _react.useCallback)(() => setFlyoutAlertIndex(-1), [setFlyoutAlertIndex]);
  const RenderCell = (0, _react.useMemo)(() => {
    var _props$alertsTableCon;
    if ((_props$alertsTableCon = props.alertsTableConfiguration) !== null && _props$alertsTableCon !== void 0 && _props$alertsTableCon.getRenderCellValue) {
      return props.alertsTableConfiguration.getRenderCellValue;
    } else {
      return FullFeaturedRenderCellValue;
    }
  }, [props.alertsTableConfiguration]);
  const renderCellContext = (0, _react.useMemo)(() => {
    const additionalContext = passedCellContext ? passedCellContext : {};
    return {
      ...additionalContext,
      ...alertsTableConfiguration,
      ecsData: ecsAlertsData,
      oldAlertsData,
      context: userAssigneeContext,
      alerts,
      browserFields,
      pagination: updatedPagination,
      isLoading,
      setFlyoutAlert: handleFlyoutAlert,
      RenderCell,
      isLoadingCases,
      isLoadingMaintenanceWindows,
      getSetIsActionLoadingCallback,
      cases,
      maintenanceWindows,
      showAlertStatusWithFlapping,
      refresh,
      clearSelection,
      renderCustomActionsRow,
      fieldFormats
    };
  }, [passedCellContext, alertsTableConfiguration, ecsAlertsData, oldAlertsData, refresh, clearSelection, renderCustomActionsRow, handleFlyoutAlert, RenderCell, browserFields, isLoading, updatedPagination, alerts, isLoadingCases, isLoadingMaintenanceWindows, cases, maintenanceWindows, showAlertStatusWithFlapping, getSetIsActionLoadingCallback, userAssigneeContext, fieldFormats]);
  const renderCellPopover = (0, _react.useMemo)(() => {
    var _props$alertsTableCon2, _props$alertsTableCon3, _props$alertsTableCon4;
    return (_props$alertsTableCon2 = (_props$alertsTableCon3 = props.alertsTableConfiguration) === null || _props$alertsTableCon3 === void 0 ? void 0 : (_props$alertsTableCon4 = _props$alertsTableCon3.getRenderCellPopover) === null || _props$alertsTableCon4 === void 0 ? void 0 : _props$alertsTableCon4.call(_props$alertsTableCon3, {
      context: renderCellContext
    })) !== null && _props$alertsTableCon2 !== void 0 ? _props$alertsTableCon2 : props.renderCellPopover;
  }, [props.alertsTableConfiguration, props.renderCellPopover, renderCellContext]);
  const handleRenderCellPopover = (0, _react.useMemo)(() => renderCellPopover ? _props => {
    try {
      const idx = _props.rowIndex - pagination.pageSize * pagination.pageIndex;
      const alert = alerts[idx];
      if (alert) {
        return renderCellPopover({
          ..._props,
          alert
        });
      }
      return null;
    } catch (e) {
      return /*#__PURE__*/_react.default.createElement(ViewError, {
        error: e
      });
    }
  } : undefined, [alerts, pagination.pageIndex, pagination.pageSize, renderCellPopover]);
  const dataGridPagination = (0, _react.useMemo)(() => ({
    pageIndex: updatedPagination.pageIndex,
    pageSize: updatedPagination.pageSize,
    pageSizeOptions: props.pageSizeOptions,
    onChangeItemsPerPage: onChangePageSize,
    onChangePage: onChangePageIndex
  }), [onChangePageIndex, onChangePageSize, updatedPagination.pageIndex, updatedPagination.pageSize, props.pageSizeOptions]);
  const {
    getCellActions,
    visibleCellActions,
    disabledCellActions
  } = alertsTableConfiguration !== null && alertsTableConfiguration !== void 0 && alertsTableConfiguration.useCellActions ? alertsTableConfiguration === null || alertsTableConfiguration === void 0 ? void 0 : alertsTableConfiguration.useCellActions({
    columns,
    data: oldAlertsData,
    ecsData: ecsAlertsData,
    dataGridRef,
    pageSize: pagination.pageSize,
    pageIndex: pagination.pageIndex
  }) : getCellActionsStub;
  const columnsWithCellActions = (0, _react.useMemo)(() => {
    if (getCellActions) {
      return columns.map((col, idx) => {
        var _getCellActions;
        return {
          ...col,
          ...(!(disabledCellActions !== null && disabledCellActions !== void 0 ? disabledCellActions : []).includes(col.id) ? {
            cellActions: (_getCellActions = getCellActions(col.id, idx)) !== null && _getCellActions !== void 0 ? _getCellActions : [],
            visibleCellActions
          } : {})
        };
      });
    }
    return columns;
  }, [getCellActions, disabledCellActions, columns, visibleCellActions]);

  // // Update highlighted rows when alerts or pagination changes
  const highlightedRowClasses = (0, _react.useMemo)(() => {
    if (shouldHighlightRow) {
      const emptyShouldHighlightRow = {};
      return alerts.reduce((rowClasses, alert, index) => {
        if (shouldHighlightRow(alert)) {
          rowClasses[index + pagination.pageIndex * pagination.pageSize] = 'alertsTableHighlightedRow';
        }
        return rowClasses;
      }, emptyShouldHighlightRow);
    } else {
      return stableMappedRowClasses;
    }
  }, [shouldHighlightRow, alerts, pagination.pageIndex, pagination.pageSize]);
  const mergedGridStyle = (0, _react.useMemo)(() => {
    var _props$gridStyle;
    const propGridStyle = (_props$gridStyle = props.gridStyle) !== null && _props$gridStyle !== void 0 ? _props$gridStyle : {};
    // Merges default row classes, custom ones and adds the active row class style
    return {
      ...DefaultGridStyle,
      ...propGridStyle,
      rowClasses: {
        // We're spreadind the highlighted row classes first, so that the active
        // row classed can override the highlighted row classes.
        ...highlightedRowClasses,
        ...activeRowClasses
      }
    };
  }, [activeRowClasses, highlightedRowClasses, props.gridStyle]);

  // Merges the default grid style with the grid style that comes in through props.
  const actualGridStyle = (0, _react.useMemo)(() => {
    var _props$gridStyle2;
    const propGridStyle = (_props$gridStyle2 = props.gridStyle) !== null && _props$gridStyle2 !== void 0 ? _props$gridStyle2 : {};
    // If ANY additional rowClasses have been provided, we need to merge them with our internal ones
    if (propGridStyle.rowClasses) {
      // Get all row indices with a rowClass.
      const mergedKeys = [...Object.keys(mergedGridStyle.rowClasses || {}), ...Object.keys(propGridStyle.rowClasses || {})];
      // Deduplicate keys to avoid extra iterations
      const dedupedKeys = Array.from(new Set(mergedKeys));

      // For each index, merge row classes
      const mergedRowClasses = dedupedKeys.reduce((rowClasses, key) => {
        var _mergedGridStyle$rowC, _propGridStyle$rowCla;
        const intKey = parseInt(key, 10);
        // Use internal row classes over custom row classes.
        rowClasses[intKey] = ((_mergedGridStyle$rowC = mergedGridStyle.rowClasses) === null || _mergedGridStyle$rowC === void 0 ? void 0 : _mergedGridStyle$rowC[intKey]) || ((_propGridStyle$rowCla = propGridStyle.rowClasses) === null || _propGridStyle$rowCla === void 0 ? void 0 : _propGridStyle$rowCla[intKey]) || '';
        return rowClasses;
      }, {});
      mergedGridStyle.rowClasses = mergedRowClasses;
    }
    return mergedGridStyle;
  }, [props.gridStyle, mergedGridStyle]);
  const renderCustomGridBody = (0, _react.useCallback)(({
    visibleColumns: _visibleColumns,
    Cell
  }) => {
    var _props$gridStyle3;
    return /*#__PURE__*/_react.default.createElement(CustomGridBody, {
      visibleColumns: _visibleColumns,
      Cell: Cell,
      actualGridStyle: actualGridStyle,
      alertsData: oldAlertsData,
      pagination: pagination,
      isLoading: isLoading,
      stripes: (_props$gridStyle3 = props.gridStyle) === null || _props$gridStyle3 === void 0 ? void 0 : _props$gridStyle3.stripes
    });
  }, [actualGridStyle, oldAlertsData, pagination, isLoading, (_props$gridStyle4 = props.gridStyle) === null || _props$gridStyle4 === void 0 ? void 0 : _props$gridStyle4.stripes]);
  const sortProps = (0, _react.useMemo)(() => {
    return {
      columns: sortingColumns,
      onSort
    };
  }, [sortingColumns, onSort]);
  const columnVisibility = (0, _react.useMemo)(() => {
    return {
      visibleColumns,
      setVisibleColumns: onChangeVisibleColumns
    };
  }, [visibleColumns, onChangeVisibleColumns]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement("section", {
    style: {
      width: '100%'
    },
    "data-test-subj": props['data-test-subj']
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, flyoutAlertIndex > -1 && /*#__PURE__*/_react.default.createElement(AlertsFlyout, {
    alert: alerts[flyoutAlertIndex],
    alertsCount: alertsCount,
    onClose: handleFlyoutClose,
    alertsTableConfiguration: alertsTableConfiguration,
    flyoutIndex: flyoutAlertIndex + pagination.pageIndex * pagination.pageSize,
    onPaginate: onPaginateFlyout,
    isLoading: isLoading,
    id: props.id
  })), alertsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": "Alerts table",
    "data-test-subj": "alertsTable",
    columns: columnsWithCellActions,
    columnVisibility: columnVisibility,
    trailingControlColumns: trailingControlColumns,
    leadingControlColumns: leadingControlColumns,
    rowCount: alertsCount,
    renderCellValue: FullFeaturedRenderCellValue,
    gridStyle: actualGridStyle,
    sorting: sortProps,
    toolbarVisibility: toolbarVisibility,
    cellContext: renderCellContext,
    pagination: dataGridPagination,
    rowHeightsOptions: rowHeightsOptions,
    onColumnResize: onColumnResize,
    ref: dataGridRef,
    renderCustomGridBody: dynamicRowHeight ? renderCustomGridBody : undefined,
    renderCellPopover: handleRenderCellPopover
  })));
});
AlertsTable.displayName = 'AlertsTable';

// eslint-disable-next-line import/no-default-export