"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackAlertsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactQuery = require("@tanstack/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _no_permission_prompt = require("../../../components/prompts/no_permission_prompt");
var _constants2 = require("../../../constants");
var _use_rule_stats = require("../hooks/use_rule_stats");
var _breadcrumb = require("../../../lib/breadcrumb");
var _constants3 = require("../../alerts_search_bar/constants");
var _constants4 = require("../../alerts_table/constants");
var _url_synced_alerts_search_bar = require("../../alerts_search_bar/url_synced_alerts_search_bar");
var _kibana = require("../../../../common/lib/kibana");
var _query_client = require("../../alerts_table/query_client");
var _use_alert_search_bar_state_container = require("../../alerts_search_bar/use_alert_search_bar_state_container");
var _doc_title = require("../../../lib/doc_title");
var _search_filters = require("../../../lib/search_filters");
var _use_load_rule_types_query = require("../../../hooks/use_load_rule_types_query");
var _utils = require("../../../../../common/utils");
var _use_rule_type_ids_by_feature_id = require("../hooks/use_rule_type_ids_by_feature_id");
var _translations = require("../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsTable = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../alerts_table/alerts_table_state'))));

/**
 * A unified view for all types of alerts
 */
const StackAlertsPage = () => {
  return /*#__PURE__*/_react.default.createElement(_use_alert_search_bar_state_container.Provider, {
    value: _use_alert_search_bar_state_container.alertSearchBarStateContainer
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.alertsTableQueryClient
  }, /*#__PURE__*/_react.default.createElement(PageContent, null)));
};
exports.StackAlertsPage = StackAlertsPage;
const getFeatureFilterLabel = featureName => _i18n.i18n.translate('xpack.triggersActionsUI.sections.stackAlertsPage.featureRuleTypes', {
  defaultMessage: '{feature} rule types',
  values: {
    feature: featureName
  }
});
const PageContent = () => {
  const {
    chrome: {
      docTitle
    },
    setBreadcrumbs,
    alertsTableConfigurationRegistry
  } = (0, _kibana.useKibana)().services;
  const [esQuery, setEsQuery] = (0, _react.useState)({
    bool: {}
  });
  const [activeFeatureFilters, setActiveFeatureFilters] = (0, _react.useState)([]);
  const ruleStats = (0, _use_rule_stats.useRuleStats)();
  const {
    ruleTypesState: {
      data: ruleTypesIndex,
      initialLoad: isInitialLoadingRuleTypes
    },
    authorizedToReadAnyRules
  } = (0, _use_load_rule_types_query.useLoadRuleTypesQuery)({
    filteredRuleTypes: []
  });
  const ruleTypeIdsByFeatureId = (0, _use_rule_type_ids_by_feature_id.useRuleTypeIdsByFeatureId)(ruleTypesIndex);
  const browsingSiem = (0, _react.useMemo)(() => activeFeatureFilters.length === 1 && activeFeatureFilters[0] === _ruleDataUtils.AlertConsumers.SIEM, [activeFeatureFilters]);
  const filteringBySolution = (0, _react.useMemo)(() => activeFeatureFilters.length > 0, [activeFeatureFilters.length]);
  const featureIds = (0, _react.useMemo)(() => filteringBySolution ? browsingSiem ? [_ruleDataUtils.AlertConsumers.SIEM] : activeFeatureFilters : _constants3.NON_SIEM_FEATURE_IDS, [activeFeatureFilters, browsingSiem, filteringBySolution]);
  const quickFilters = (0, _react.useMemo)(() => {
    const filters = [];
    if (Object.values(ruleTypeIdsByFeatureId).length > 0) {
      filters.push(...Object.entries(ruleTypeIdsByFeatureId).map(([featureId, ruleTypeIds]) => {
        var _producerData$subFeat;
        const producerData = _constants4.alertProducersData[featureId];
        if (!producerData) {
          return null;
        }
        const filterLabel = getFeatureFilterLabel(producerData.displayName);
        const disabled = filteringBySolution && featureId === _ruleDataUtils.AlertConsumers.SIEM ? !browsingSiem : browsingSiem;
        return {
          name: filterLabel,
          icon: producerData.icon,
          filter: (0, _search_filters.createRuleTypesFilter)((_producerData$subFeat = producerData.subFeatureIds) !== null && _producerData$subFeat !== void 0 ? _producerData$subFeat : [featureId], filterLabel, ruleTypeIds),
          disabled
        };
      }).filter(_utils.nonNullable));
    }
    filters.push({
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.globalAlerts.quickFilters.status', {
        defaultMessage: 'Status'
      }),
      icon: 'bell',
      items: [_ruleDataUtils.ALERT_STATUS_ACTIVE, _ruleDataUtils.ALERT_STATUS_RECOVERED, _ruleDataUtils.ALERT_STATUS_UNTRACKED].map(s => ({
        name: s,
        filter: (0, _search_filters.createMatchPhraseFilter)(_ruleDataUtils.ALERT_STATUS, s)
      }))
    });
    return filters;
  }, [browsingSiem, filteringBySolution, ruleTypeIdsByFeatureId]);
  const tableConfigurationId = (0, _react.useMemo)(
  // TODO in preparation for using solution-specific configurations
  () => _constants2.ALERT_TABLE_GLOBAL_CONFIG_ID, []);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('alerts')]);
    docTitle.change((0, _doc_title.getCurrentDocTitle)('alerts'));
  }, [docTitle, setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    paddingSize: "none",
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.managementSection.alerts.displayName",
      defaultMessage: "Alerts"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _translations.TECH_PREVIEW_LABEL,
      tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION
    }))),
    bottomBorder: true,
    rightSideItems: ruleStats
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), !isInitialLoadingRuleTypes && !authorizedToReadAnyRules ? /*#__PURE__*/_react.default.createElement(_no_permission_prompt.NoPermissionPrompt, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    "data-test-subj": "stackAlertsPageContent"
  }, /*#__PURE__*/_react.default.createElement(_url_synced_alerts_search_bar.UrlSyncedAlertsSearchBar, {
    appName: _constants.ALERTS_PAGE_ID,
    featureIds: featureIds,
    showFilterControls: true,
    showFilterBar: true,
    quickFilters: quickFilters,
    onActiveFeatureFiltersChange: setActiveFeatureFilters,
    onEsQueryChange: setEsQuery
  }), /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(AlertsTable
  // Here we force a rerender when switching feature ids to prevent the data grid
  // columns alignment from breaking after a change in the number of columns
  , {
    key: featureIds.join(),
    id: "stack-alerts-page-table",
    configurationId: tableConfigurationId,
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    featureIds: featureIds,
    query: esQuery,
    showAlertStatusWithFlapping: true,
    pageSize: 20
  }))));
};