"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rewriteBodyRequest = exports.UPDATE_FIELDS = void 0;
exports.updateRule = updateRule;
var _lodash = require("lodash");
var _constants = require("../../constants");
var _common_transformations = require("./common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_FIELDS = exports.UPDATE_FIELDS = ['name', 'tags', 'schedule', 'params', 'actions', 'alertDelay'];
const rewriteBodyRequest = ({
  actions,
  alertDelay,
  ...res
}) => ({
  ...res,
  actions: actions.map(action => {
    const {
      id,
      params,
      uuid
    } = action;
    return {
      ...('group' in action ? {
        group: action.group
      } : {}),
      id,
      params,
      ...('frequency' in action ? {
        frequency: action.frequency ? {
          notify_when: action.frequency.notifyWhen,
          throttle: action.frequency.throttle,
          summary: action.frequency.summary
        } : undefined
      } : {}),
      ...('alertsFilter' in action ? {
        alerts_filter: action.alertsFilter
      } : {}),
      ...('useAlertDataForTemplate' in action && typeof action.useAlertDataForTemplate !== 'undefined' ? {
        use_alert_data_for_template: action.useAlertDataForTemplate
      } : {}),
      ...(uuid && {
        uuid
      })
    };
  }),
  ...(alertDelay ? {
    alert_delay: alertDelay
  } : {})
});
exports.rewriteBodyRequest = rewriteBodyRequest;
async function updateRule({
  http,
  rule,
  id
}) {
  const res = await http.put(`${_constants.BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(id)}`, {
    body: JSON.stringify(rewriteBodyRequest((0, _lodash.pick)(rule, UPDATE_FIELDS)))
  });
  return (0, _common_transformations.transformRule)(res);
}