"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRuleAggregationsWithKueryFilter = loadRuleAggregationsWithKueryFilter;
var _constants = require("../../constants");
var _aggregate_helpers = require("./aggregate_helpers");
var _map_filters_to_kuery_node = require("./map_filters_to_kuery_node");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRuleAggregationsWithKueryFilter({
  http,
  searchText,
  typesFilter,
  actionTypesFilter,
  ruleExecutionStatusesFilter,
  ruleStatusesFilter,
  tagsFilter,
  filterConsumers
}) {
  const filtersKueryNode = (0, _map_filters_to_kuery_node.mapFiltersToKueryNode)({
    typesFilter,
    actionTypesFilter,
    tagsFilter,
    ruleExecutionStatusesFilter,
    ruleStatusesFilter,
    searchText
  });
  const res = await http.post(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_aggregate`, {
    body: JSON.stringify({
      ...(filtersKueryNode ? {
        filter: JSON.stringify(filtersKueryNode)
      } : {}),
      filter_consumers: filterConsumers,
      default_search_operator: 'AND'
    })
  });
  return (0, _aggregate_helpers.rewriteBodyRes)(res);
}