"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasAllPrivilege = hasAllPrivilege;
exports.hasAllPrivilegeWithProducerCheck = hasAllPrivilegeWithProducerCheck;
exports.hasManageApiKeysCapability = exports.hasExecuteActionsCapability = exports.hasDeleteActionsCapability = void 0;
exports.hasReadPrivilege = hasReadPrivilege;
exports.hasShowActionsCapability = exports.hasSaveActionsCapability = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * NOTE: Applications that want to show the alerting UIs will need to add
 * check against their features here until we have a better solution. This
 * will possibly go away with https://github.com/elastic/kibana/issues/52300.
 */

const hasShowActionsCapability = capabilities => {
  var _capabilities$actions;
  return capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.show;
};
exports.hasShowActionsCapability = hasShowActionsCapability;
const hasSaveActionsCapability = capabilities => {
  var _capabilities$actions2;
  return capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions2 = capabilities.actions) === null || _capabilities$actions2 === void 0 ? void 0 : _capabilities$actions2.save;
};
exports.hasSaveActionsCapability = hasSaveActionsCapability;
const hasExecuteActionsCapability = (capabilities, actionTypeId) => {
  var _capabilities$actions3, _capabilities$actions4;
  return actionTypeId === '.sentinelone' ? capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions3 = capabilities.actions) === null || _capabilities$actions3 === void 0 ? void 0 : _capabilities$actions3.save : capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions4 = capabilities.actions) === null || _capabilities$actions4 === void 0 ? void 0 : _capabilities$actions4.execute;
};
exports.hasExecuteActionsCapability = hasExecuteActionsCapability;
const hasDeleteActionsCapability = capabilities => {
  var _capabilities$actions5;
  return capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$actions5 = capabilities.actions) === null || _capabilities$actions5 === void 0 ? void 0 : _capabilities$actions5.delete;
};
exports.hasDeleteActionsCapability = hasDeleteActionsCapability;
function hasAllPrivilege(ruleConsumer, ruleType) {
  var _ruleType$authorizedC, _ruleType$authorizedC2;
  return (_ruleType$authorizedC = ruleType === null || ruleType === void 0 ? void 0 : (_ruleType$authorizedC2 = ruleType.authorizedConsumers[ruleConsumer]) === null || _ruleType$authorizedC2 === void 0 ? void 0 : _ruleType$authorizedC2.all) !== null && _ruleType$authorizedC !== void 0 ? _ruleType$authorizedC : false;
}
function hasAllPrivilegeWithProducerCheck(ruleConsumer, ruleType) {
  if (ruleConsumer === (ruleType === null || ruleType === void 0 ? void 0 : ruleType.producer)) {
    return true;
  }
  return hasAllPrivilege(ruleConsumer, ruleType);
}
function hasReadPrivilege(rule, ruleType) {
  var _ruleType$authorizedC3, _ruleType$authorizedC4;
  return (_ruleType$authorizedC3 = ruleType === null || ruleType === void 0 ? void 0 : (_ruleType$authorizedC4 = ruleType.authorizedConsumers[rule.consumer]) === null || _ruleType$authorizedC4 === void 0 ? void 0 : _ruleType$authorizedC4.read) !== null && _ruleType$authorizedC3 !== void 0 ? _ruleType$authorizedC3 : false;
}
const hasManageApiKeysCapability = capabilities => {
  var _capabilities$managem, _capabilities$managem2;
  return capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem = capabilities.management) === null || _capabilities$managem === void 0 ? void 0 : (_capabilities$managem2 = _capabilities$managem.security) === null || _capabilities$managem2 === void 0 ? void 0 : _capabilities$managem2.api_keys;
};
exports.hasManageApiKeysCapability = hasManageApiKeysCapability;