"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAllActions = loadAllActions;
var _common = require("@kbn/actions-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteResponseRes = results => {
  return results.map(item => transformConnector(item));
};
const transformConnector = ({
  connector_type_id: actionTypeId,
  is_preconfigured: isPreconfigured,
  is_deprecated: isDeprecated,
  referenced_by_count: referencedByCount,
  is_missing_secrets: isMissingSecrets,
  is_system_action: isSystemAction,
  ...res
}) => ({
  actionTypeId,
  isPreconfigured,
  isDeprecated,
  referencedByCount,
  isMissingSecrets,
  isSystemAction,
  ...res
});
async function loadAllActions({
  http,
  includeSystemActions = false
}) {
  // Use the internal get_all_system route to load all action connectors and preconfigured system action connectors
  // This is necessary to load UI elements that require system action connectors, even if they're not selectable and
  // editable from the connector selection UI like a normal action connector.
  const path = includeSystemActions ? `${_common.INTERNAL_BASE_ACTION_API_PATH}/connectors` : `${_common.BASE_ACTION_API_PATH}/connectors`;
  const res = await http.get(path);
  return rewriteResponseRes(res);
}