"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRulesQuery = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _rules_kuery_filter = require("../lib/rule_api/rules_kuery_filter");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLoadRulesQuery = props => {
  var _rulesResponse$data, _rulesResponse$total;
  const {
    filterConsumers,
    filters,
    page,
    sort,
    onPage,
    enabled,
    refresh,
    hasReference
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    refetch,
    isLoading,
    data: rulesResponse,
    dataUpdatedAt,
    isInitialLoading,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadRules', filters.tags, filters.searchText, filters.types, filters.actionTypes, filters.ruleStatuses, filters.ruleLastRunOutcomes, filters.ruleParams, filters.kueryNode, page, sort, {
      refresh: refresh === null || refresh === void 0 ? void 0 : refresh.toISOString()
    }, filterConsumers, hasReference],
    queryFn: () => {
      return (0, _rules_kuery_filter.loadRulesWithKueryFilter)({
        http,
        page,
        searchText: filters.searchText,
        typesFilter: filters.types,
        actionTypesFilter: filters.actionTypes,
        ruleExecutionStatusesFilter: filters.ruleExecutionStatuses,
        ruleLastRunOutcomesFilter: filters.ruleLastRunOutcomes,
        ruleParamsFilter: filters.ruleParams,
        ruleStatusesFilter: filters.ruleStatuses,
        tagsFilter: filters.tags,
        kueryNode: filters.kueryNode,
        sort,
        filterConsumers,
        hasReference
      });
    },
    onSuccess: response => {
      var _response$data;
      if (!(response !== null && response !== void 0 && (_response$data = response.data) !== null && _response$data !== void 0 && _response$data.length) && page.index > 0) {
        onPage({
          ...page,
          index: 0
        });
      }
    },
    onError: () => {
      toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToLoadRulesMessage', {
        defaultMessage: 'Unable to load rules'
      }));
    },
    enabled,
    keepPreviousData: true,
    cacheTime: 0,
    refetchOnWindowFocus: false
  });
  const hasData = Boolean(rulesResponse && rulesResponse.data.length > 0);
  return {
    rulesState: {
      isLoading: enabled && (isLoading || isFetching),
      data: (_rulesResponse$data = rulesResponse === null || rulesResponse === void 0 ? void 0 : rulesResponse.data) !== null && _rulesResponse$data !== void 0 ? _rulesResponse$data : [],
      totalItemCount: (_rulesResponse$total = rulesResponse === null || rulesResponse === void 0 ? void 0 : rulesResponse.total) !== null && _rulesResponse$total !== void 0 ? _rulesResponse$total : 0,
      initialLoad: isLoading || isInitialLoading
    },
    lastUpdate: (0, _moment.default)(dataUpdatedAt).format(),
    hasData,
    loadRules: refetch
  };
};
exports.useLoadRulesQuery = useLoadRulesQuery;