"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRuleEventLogs = useLoadRuleEventLogs;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _kibana = require("../../common/lib/kibana");
var _load_execution_log_aggregations = require("../lib/rule_api/load_execution_log_aggregations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedDate = date => {
  if (date.includes('now')) {
    var _datemath$parse;
    return ((_datemath$parse = _datemath.default.parse(date)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.format()) || date;
  }
  return date;
};
const isGlobal = props => {
  return props.id === '*';
};
function useLoadRuleEventLogs(props) {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const queryFn = (0, _react.useCallback)(() => {
    if (isGlobal(props)) {
      return (0, _load_execution_log_aggregations.loadGlobalExecutionLogAggregations)({
        http,
        ...props,
        dateStart: getParsedDate(props.dateStart),
        ...(props.dateEnd ? {
          dateEnd: getParsedDate(props.dateEnd)
        } : {})
      });
    }
    return (0, _load_execution_log_aggregations.loadExecutionLogAggregations)({
      http,
      ...props,
      dateStart: getParsedDate(props.dateStart),
      ...(props.dateEnd ? {
        dateEnd: getParsedDate(props.dateEnd)
      } : {})
    });
  }, [props, http]);
  const {
    data,
    error,
    isLoading,
    isFetching,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadRuleEventLog', props],
    queryFn,
    onError: props.onError,
    retry: 0,
    refetchOnWindowFocus: false
  });
  const hasExceedLogs = (0, _react.useMemo)(() => error && error.body.statusCode === 413, [error]);
  return (0, _react.useMemo)(() => ({
    data,
    hasExceedLogs,
    isLoading: isLoading || isFetching,
    loadEventLogs: refetch
  }), [data, hasExceedLogs, isFetching, isLoading, refetch]);
}